/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import javax.annotation.Nonnull;
import me.lucko.luckperms.api.FullySatisfiedContexts;
import me.lucko.luckperms.api.context.ContextSet;

public class Contexts {
    public static final String SERVER_KEY = "server";
    public static final String WORLD_KEY = "world";
    private static final Contexts GLOBAL = new Contexts(ContextSet.empty(), true, true, true, true, true, false);
    private final ContextSet context;
    private final boolean op;
    private final boolean includeGlobal;
    private final boolean includeGlobalWorld;
    private final boolean applyGroups;
    private final boolean applyGlobalGroups;
    private final boolean applyGlobalWorldGroups;

    @Nonnull
    public static Contexts allowAll() {
        return FullySatisfiedContexts.getInstance();
    }

    @Nonnull
    public static Contexts global() {
        return GLOBAL;
    }

    public static Contexts of(@Nonnull ContextSet context, boolean includeGlobal, boolean includeGlobalWorld, boolean applyGroups, boolean applyGlobalGroups, boolean applyGlobalWorldGroups, boolean op) {
        return new Contexts(context, includeGlobal, includeGlobalWorld, applyGroups, applyGlobalGroups, applyGlobalWorldGroups, op);
    }

    public Contexts(@Nonnull ContextSet context, boolean includeGlobal, boolean includeGlobalWorld, boolean applyGroups, boolean applyGlobalGroups, boolean applyGlobalWorldGroups, boolean op) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.context = context.makeImmutable();
        this.includeGlobal = includeGlobal;
        this.includeGlobalWorld = includeGlobalWorld;
        this.applyGroups = applyGroups;
        this.applyGlobalGroups = applyGlobalGroups;
        this.applyGlobalWorldGroups = applyGlobalWorldGroups;
        this.op = op;
    }

    @Nonnull
    public ContextSet getContexts() {
        return this.context;
    }

    public boolean isOp() {
        return this.op;
    }

    public boolean isIncludeGlobal() {
        return this.includeGlobal;
    }

    public boolean isIncludeGlobalWorld() {
        return this.includeGlobalWorld;
    }

    public boolean isApplyGroups() {
        return this.applyGroups;
    }

    public boolean isApplyGlobalGroups() {
        return this.applyGlobalGroups;
    }

    public boolean isApplyGlobalWorldGroups() {
        return this.applyGlobalWorldGroups;
    }

    @Nonnull
    public String toString() {
        return "Contexts(context=" + this.getContexts() + ", op=" + this.isOp() + ", includeGlobal=" + this.isIncludeGlobal() + ", includeGlobalWorld=" + this.isIncludeGlobalWorld() + ", applyGroups=" + this.isApplyGroups() + ", applyGlobalGroups=" + this.isApplyGlobalGroups() + ", applyGlobalWorldGroups=" + this.isApplyGlobalWorldGroups() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == Contexts.allowAll()) {
            return false;
        }
        if (!(o instanceof Contexts)) {
            return false;
        }
        Contexts other = (Contexts)o;
        return this.getContexts().equals(other.getContexts()) && this.isOp() == other.isOp() && this.isIncludeGlobal() == other.isIncludeGlobal() && this.isIncludeGlobalWorld() == other.isIncludeGlobalWorld() && this.isApplyGroups() == other.isApplyGroups() && this.isApplyGlobalGroups() == other.isApplyGlobalGroups() && this.isApplyGlobalWorldGroups() == other.isApplyGlobalWorldGroups();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContextSet contexts = this.getContexts();
        result = result * 59 + contexts.hashCode();
        result = result * 59 + (this.isOp() ? 79 : 97);
        result = result * 59 + (this.isIncludeGlobal() ? 79 : 97);
        result = result * 59 + (this.isIncludeGlobalWorld() ? 79 : 97);
        result = result * 59 + (this.isApplyGroups() ? 79 : 97);
        result = result * 59 + (this.isApplyGlobalGroups() ? 79 : 97);
        result = result * 59 + (this.isApplyGlobalWorldGroups() ? 79 : 97);
        return result;
    }
}

