/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.ImmutableContextSet;

public final class MutableContextSet
implements ContextSet {
    private final Multimap<String, String> map;

    public static MutableContextSet singleton(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        MutableContextSet set = new MutableContextSet();
        set.add(key, value);
        return set;
    }

    public static MutableContextSet fromMap(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        MutableContextSet set = new MutableContextSet();
        set.addAll(map);
        return set;
    }

    public static MutableContextSet fromEntries(Iterable<? extends Map.Entry<String, String>> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        MutableContextSet set = new MutableContextSet();
        set.addAll(iterable);
        return set;
    }

    public static MutableContextSet fromMultimap(Multimap<String, String> multimap) {
        if (multimap == null) {
            throw new NullPointerException("multimap");
        }
        return MutableContextSet.fromEntries(multimap.entries());
    }

    public static MutableContextSet fromSet(ContextSet contextSet) {
        if (contextSet == null) {
            throw new NullPointerException("contextSet");
        }
        MutableContextSet set = new MutableContextSet();
        set.addAll(contextSet.toSet());
        return set;
    }

    public static MutableContextSet create() {
        return new MutableContextSet();
    }

    public MutableContextSet() {
        this.map = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    }

    private MutableContextSet(Multimap<String, String> contexts) {
        this.map = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create(contexts));
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public ImmutableContextSet makeImmutable() {
        return new ImmutableContextSet(this.map);
    }

    @Override
    public MutableContextSet mutableCopy() {
        return new MutableContextSet(this.map);
    }

    @Override
    public Set<Map.Entry<String, String>> toSet() {
        return ImmutableSet.copyOf((Collection)this.map.entries());
    }

    @Override
    public Map<String, String> toMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (Map.Entry e : this.map.entries()) {
            m.put(e.getKey(), e.getValue());
        }
        return m.build();
    }

    @Override
    public Multimap<String, String> toMultimap() {
        return this.map;
    }

    @Override
    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.map.containsKey((Object)key);
    }

    @Override
    public Set<String> getValues(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Collection c = this.map.get((Object)key);
        return c != null && !c.isEmpty() ? ImmutableSet.copyOf((Collection)c) : ImmutableSet.of();
    }

    @Override
    public boolean has(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.map.containsEntry((Object)key, (Object)value);
    }

    @Override
    public boolean hasIgnoreCase(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Collection c = this.map.get((Object)key);
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (String val : c) {
            if (!val.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public void add(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.map.put((Object)key.toLowerCase(), (Object)value);
    }

    public void add(Map.Entry<String, String> entry) {
        if (entry == null) {
            throw new NullPointerException("context");
        }
        this.map.put((Object)entry.getKey().toLowerCase(), (Object)entry.getValue());
    }

    public void addAll(Iterable<? extends Map.Entry<String, String>> iterable) {
        if (iterable == null) {
            throw new NullPointerException("contexts");
        }
        for (Map.Entry<String, String> entry : iterable) {
            this.map.put((Object)entry.getKey().toLowerCase(), (Object)entry.getValue());
        }
    }

    public void addAll(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("contexts");
        }
        this.addAll(map.entrySet());
    }

    public void addAll(ContextSet contextSet) {
        if (contextSet == null) {
            throw new NullPointerException("contextSet");
        }
        this.map.putAll(contextSet.toMultimap());
    }

    public void remove(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.map.entries().removeIf(entry -> ((String)entry.getKey()).equalsIgnoreCase(key) && ((String)entry.getValue()).equals(value));
    }

    public void removeIgnoreCase(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.map.entries().removeIf(e -> ((String)e.getKey()).equalsIgnoreCase(key) && ((String)e.getValue()).equalsIgnoreCase(value));
    }

    public void removeAll(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.map.removeAll((Object)key.toLowerCase());
    }

    public void clear() {
        this.map.clear();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet other = (ContextSet)o;
        Multimap<String, String> thisContexts = this.toMultimap();
        Multimap<String, String> otherContexts = other.toMultimap();
        return thisContexts == null ? otherContexts == null : thisContexts.equals(otherContexts);
    }

    public int hashCode() {
        return 59 + (this.map == null ? 43 : this.map.hashCode());
    }

    public String toString() {
        return "MutableContextSet(contexts=" + this.map + ")";
    }
}

