/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import me.lucko.luckperms.api.context.ContextSet;
import me.lucko.luckperms.api.context.MutableContextSet;

public final class ImmutableContextSet
implements ContextSet {
    private static final ImmutableContextSet EMPTY = new ImmutableContextSet((Multimap<String, String>)ImmutableMultimap.of());
    private final Multimap<String, String> map;

    public static ImmutableContextSet singleton(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return new ImmutableContextSet((Multimap<String, String>)ImmutableMultimap.of((Object)key.toLowerCase(), (Object)value));
    }

    public static ImmutableContextSet fromMap(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        ImmutableMultimap.Builder b = ImmutableMultimap.builder();
        for (Map.Entry<String, String> e : map.entrySet()) {
            b.put((Object)e.getKey(), (Object)e.getValue());
        }
        return new ImmutableContextSet((Multimap<String, String>)b.build());
    }

    public static ImmutableContextSet fromEntries(Iterable<? extends Map.Entry<String, String>> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        return MutableContextSet.fromEntries(iterable).makeImmutable();
    }

    public static ImmutableContextSet fromMultimap(Multimap<String, String> multimap) {
        if (multimap == null) {
            throw new NullPointerException("multimap");
        }
        return MutableContextSet.fromMultimap(multimap).makeImmutable();
    }

    public static ImmutableContextSet fromSet(ContextSet contextSet) {
        return contextSet.makeImmutable();
    }

    public static ImmutableContextSet empty() {
        return EMPTY;
    }

    ImmutableContextSet(Multimap<String, String> contexts) {
        this.map = ImmutableMultimap.copyOf(contexts);
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    @Deprecated
    public ImmutableContextSet makeImmutable() {
        return this;
    }

    @Override
    public MutableContextSet mutableCopy() {
        return MutableContextSet.fromSet(this);
    }

    @Override
    public Set<Map.Entry<String, String>> toSet() {
        return ImmutableSet.copyOf((Collection)this.map.entries());
    }

    @Override
    public Map<String, String> toMap() {
        ImmutableMap.Builder m = ImmutableMap.builder();
        for (Map.Entry e : this.map.entries()) {
            m.put(e.getKey(), e.getValue());
        }
        return m.build();
    }

    @Override
    public Multimap<String, String> toMultimap() {
        return this.map;
    }

    @Override
    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.map.containsKey((Object)key);
    }

    @Override
    public Set<String> getValues(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Collection c = this.map.get((Object)key);
        return c != null && !c.isEmpty() ? ImmutableSet.copyOf((Collection)c) : ImmutableSet.of();
    }

    @Override
    public boolean has(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.map.containsEntry((Object)key, (Object)value);
    }

    @Override
    public boolean hasIgnoreCase(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Collection c = this.map.get((Object)key);
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (String val : c) {
            if (!val.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet other = (ContextSet)o;
        Multimap<String, String> thisContexts = this.toMultimap();
        Multimap<String, String> otherContexts = other.toMultimap();
        return thisContexts == null ? otherContexts == null : thisContexts.equals(otherContexts);
    }

    public int hashCode() {
        return 59 + (this.map == null ? 43 : this.map.hashCode());
    }

    public String toString() {
        return "ImmutableContextSet(contexts=" + this.map + ")";
    }
}

