/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import me.lucko.luckperms.api.Group;
import me.lucko.luckperms.api.HeldPermission;
import me.lucko.luckperms.api.Log;
import me.lucko.luckperms.api.LogEntry;
import me.lucko.luckperms.api.Track;
import me.lucko.luckperms.api.User;

public interface Storage {
    public String getName();

    public boolean isAcceptingLogins();

    public Executor getSyncExecutor();

    public Executor getAsyncExecutor();

    public CompletableFuture<Boolean> logAction(LogEntry var1);

    public CompletableFuture<Log> getLog();

    public CompletableFuture<Boolean> loadUser(UUID var1, String var2);

    public CompletableFuture<Boolean> saveUser(User var1);

    public CompletableFuture<Boolean> cleanupUsers();

    public CompletableFuture<Set<UUID>> getUniqueUsers();

    public CompletableFuture<List<HeldPermission<UUID>>> getUsersWithPermission(String var1);

    public CompletableFuture<Boolean> createAndLoadGroup(String var1);

    public CompletableFuture<Boolean> loadGroup(String var1);

    public CompletableFuture<Boolean> loadAllGroups();

    public CompletableFuture<Boolean> saveGroup(Group var1);

    public CompletableFuture<Boolean> deleteGroup(Group var1);

    public CompletableFuture<List<HeldPermission<String>>> getGroupsWithPermission(String var1);

    public CompletableFuture<Boolean> createAndLoadTrack(String var1);

    public CompletableFuture<Boolean> loadTrack(String var1);

    public CompletableFuture<Boolean> loadAllTracks();

    public CompletableFuture<Boolean> saveTrack(Track var1);

    public CompletableFuture<Boolean> deleteTrack(Track var1);

    public CompletableFuture<Boolean> saveUUIDData(String var1, UUID var2);

    public CompletableFuture<UUID> getUUID(String var1);

    public CompletableFuture<String> getName(UUID var1);
}

