/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import me.lucko.luckperms.api.context.ContextSet;

public class Contexts {
    public static final String SERVER_KEY = "server";
    public static final String WORLD_KEY = "world";
    private static final Contexts ALLOW_ALL = new Contexts(ContextSet.empty(), true, true, true, true, true, true);
    private final ContextSet context;
    private final boolean op;
    private final boolean includeGlobal;
    private final boolean includeGlobalWorld;
    private final boolean applyGroups;
    private final boolean applyGlobalGroups;
    private final boolean applyGlobalWorldGroups;

    public static Contexts allowAll() {
        return ALLOW_ALL;
    }

    public static Contexts of(ContextSet context, boolean includeGlobal, boolean includeGlobalWorld, boolean applyGroups, boolean applyGlobalGroups, boolean applyGlobalWorldGroups, boolean op) {
        return new Contexts(context, includeGlobal, includeGlobalWorld, applyGroups, applyGlobalGroups, applyGlobalWorldGroups, op);
    }

    public Contexts(ContextSet context, boolean includeGlobal, boolean includeGlobalWorld, boolean applyGroups, boolean applyGlobalGroups, boolean applyGlobalWorldGroups, boolean op) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.context = context.makeImmutable();
        this.includeGlobal = includeGlobal;
        this.includeGlobalWorld = includeGlobalWorld;
        this.applyGroups = applyGroups;
        this.applyGlobalGroups = applyGlobalGroups;
        this.applyGlobalWorldGroups = applyGlobalWorldGroups;
        this.op = op;
    }

    public ContextSet getContexts() {
        return this.context;
    }

    public boolean isOp() {
        return this.op;
    }

    public boolean isIncludeGlobal() {
        return this.includeGlobal;
    }

    public boolean isIncludeGlobalWorld() {
        return this.includeGlobalWorld;
    }

    public boolean isApplyGroups() {
        return this.applyGroups;
    }

    public boolean isApplyGlobalGroups() {
        return this.applyGlobalGroups;
    }

    public boolean isApplyGlobalWorldGroups() {
        return this.applyGlobalWorldGroups;
    }

    public String toString() {
        return "Contexts(context=" + this.getContexts() + ", op=" + this.isOp() + ", includeGlobal=" + this.isIncludeGlobal() + ", includeGlobalWorld=" + this.isIncludeGlobalWorld() + ", applyGroups=" + this.isApplyGroups() + ", applyGlobalGroups=" + this.isApplyGlobalGroups() + ", applyGlobalWorldGroups=" + this.isApplyGlobalWorldGroups() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contexts)) {
            return false;
        }
        Contexts other = (Contexts)o;
        ContextSet this$context = this.getContexts();
        ContextSet other$context = other.getContexts();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        if (this.isOp() != other.isOp()) {
            return false;
        }
        if (this.isIncludeGlobal() != other.isIncludeGlobal()) {
            return false;
        }
        if (this.isIncludeGlobalWorld() != other.isIncludeGlobalWorld()) {
            return false;
        }
        if (this.isApplyGroups() != other.isApplyGroups()) {
            return false;
        }
        if (this.isApplyGlobalGroups() != other.isApplyGlobalGroups()) {
            return false;
        }
        return this.isApplyGlobalWorldGroups() == other.isApplyGlobalWorldGroups();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContextSet $context = this.getContexts();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        result = result * 59 + (this.isOp() ? 79 : 97);
        result = result * 59 + (this.isIncludeGlobal() ? 79 : 97);
        result = result * 59 + (this.isIncludeGlobalWorld() ? 79 : 97);
        result = result * 59 + (this.isApplyGroups() ? 79 : 97);
        result = result * 59 + (this.isApplyGlobalGroups() ? 79 : 97);
        result = result * 59 + (this.isApplyGlobalWorldGroups() ? 79 : 97);
        return result;
    }
}

