/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.lucko.luckperms.api.context.ContextSet;

public class MutableContextSet
extends ContextSet {
    public static MutableContextSet singleton(String key, String value) {
        MutableContextSet set = new MutableContextSet();
        set.add(key, value);
        return set;
    }

    public static MutableContextSet fromMap(Map<String, String> map) {
        MutableContextSet set = new MutableContextSet();
        set.addAll(map);
        return set;
    }

    public static MutableContextSet fromEntries(Iterable<Map.Entry<String, String>> iterable) {
        MutableContextSet set = new MutableContextSet();
        set.addAll(iterable);
        return set;
    }

    public static MutableContextSet fromSet(ContextSet contextSet) {
        MutableContextSet set = new MutableContextSet();
        set.addAll(contextSet.toSet());
        return set;
    }

    public static MutableContextSet empty() {
        return new MutableContextSet();
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public ContextSet makeImmutable() {
        return this.immutableCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextSet immutableCopy() {
        Set set = this.contexts;
        synchronized (set) {
            return new ContextSet(new HashSet<Map.Entry<String, String>>(this.contexts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Set set = this.contexts;
        synchronized (set) {
            this.contexts.add(Maps.immutableEntry((Object)key, (Object)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Map.Entry<String, String> entry) {
        if (entry == null) {
            throw new NullPointerException("context");
        }
        Set set = this.contexts;
        synchronized (set) {
            this.contexts.add(Maps.immutableEntry((Object)entry.getKey(), (Object)entry.getValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Iterable<Map.Entry<String, String>> iterable) {
        if (iterable == null) {
            throw new NullPointerException("contexts");
        }
        Set set = this.contexts;
        synchronized (set) {
            for (Map.Entry<String, String> e : iterable) {
                this.contexts.add(Maps.immutableEntry((Object)e.getKey(), (Object)e.getValue()));
            }
        }
    }

    public void addAll(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("contexts");
        }
        this.addAll(map.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(ContextSet contextSet) {
        if (contextSet == null) {
            throw new NullPointerException("contextSet");
        }
        Set set = this.contexts;
        synchronized (set) {
            this.contexts.addAll(contextSet.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Set set = this.contexts;
        synchronized (set) {
            this.contexts.removeIf(e -> ((String)e.getKey()).equalsIgnoreCase(key) && ((String)e.getValue()).equals(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIgnoreCase(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Set set = this.contexts;
        synchronized (set) {
            this.contexts.removeIf(e -> ((String)e.getKey()).equalsIgnoreCase(key) && ((String)e.getValue()).equalsIgnoreCase(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Set set = this.contexts;
        synchronized (set) {
            this.contexts.removeIf(e -> ((String)e.getKey()).equalsIgnoreCase(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set set = this.contexts;
        synchronized (set) {
            this.contexts.clear();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet other = (ContextSet)o;
        Set thisContexts = this.contexts;
        Set<Map.Entry<String, String>> otherContexts = other.contexts;
        return thisContexts == null ? otherContexts == null : ((Object)thisContexts).equals(otherContexts);
    }

    @Override
    public int hashCode() {
        return 59 + (this.contexts == null ? 43 : this.contexts.hashCode());
    }
}

