/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.context.ContextSet;

public interface Node
extends Map.Entry<String, Boolean> {
    public String getPermission();

    @Override
    public Boolean getValue();

    public Tristate getTristate();

    public boolean isNegated();

    public boolean isOverride();

    public Optional<String> getServer();

    public Optional<String> getWorld();

    public boolean isServerSpecific();

    public boolean isWorldSpecific();

    public boolean shouldApplyOnServer(String var1, boolean var2, boolean var3);

    public boolean shouldApplyOnWorld(String var1, boolean var2, boolean var3);

    public boolean shouldApplyWithContext(ContextSet var1, boolean var2);

    public boolean shouldApplyWithContext(ContextSet var1);

    @Deprecated
    default public boolean shouldApplyWithContext(Map<String, String> context, boolean worldAndServer) {
        return this.shouldApplyWithContext(ContextSet.fromMap(context), worldAndServer);
    }

    @Deprecated
    default public boolean shouldApplyWithContext(Map<String, String> context) {
        return this.shouldApplyWithContext(ContextSet.fromMap(context));
    }

    public boolean shouldApplyOnAnyServers(List<String> var1, boolean var2);

    public boolean shouldApplyOnAnyWorlds(List<String> var1, boolean var2);

    public List<String> resolveWildcard(List<String> var1);

    public List<String> resolveShorthand();

    public boolean isTemporary();

    public boolean isPermanent();

    public long getExpiryUnixTime();

    public Date getExpiry();

    public long getSecondsTilExpiry();

    public boolean hasExpired();

    @Deprecated
    default public Map<String, String> getExtraContexts() {
        return this.getContexts().toMap();
    }

    public ContextSet getContexts();

    public String toSerializedNode();

    public boolean isGroupNode();

    public String getGroupName();

    public boolean isWildcard();

    public int getWildcardLevel();

    public boolean isMeta();

    public Map.Entry<String, String> getMeta();

    public boolean isPrefix();

    public Map.Entry<Integer, String> getPrefix();

    public boolean isSuffix();

    public Map.Entry<Integer, String> getSuffix();

    @Override
    public boolean equals(Object var1);

    public boolean equalsIgnoringValue(Node var1);

    public boolean almostEquals(Node var1);

    public boolean equalsIgnoringValueOrTemp(Node var1);

    public static interface Builder {
        public Builder setNegated(boolean var1);

        public Builder setValue(boolean var1);

        public Builder setOverride(boolean var1);

        public Builder setExpiry(long var1);

        public Builder setWorld(String var1);

        public Builder setServer(String var1) throws IllegalArgumentException;

        public Builder withExtraContext(String var1, String var2);

        public Builder withExtraContext(Map<String, String> var1);

        public Builder withExtraContext(Set<Map.Entry<String, String>> var1);

        public Builder withExtraContext(Map.Entry<String, String> var1);

        public Builder withExtraContext(ContextSet var1);

        public Node build();
    }
}

