/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api;

import java.util.UUID;

public class LogEntry
implements Comparable<LogEntry> {
    private static final String FORMAT = "&8(&e%s&8) [&a%s&8] (&b%s&8) &7--> &f%s";
    private long timestamp;
    private UUID actor;
    private String actorName;
    private char type;
    private UUID acted;
    private String actedName;
    private String action;

    public static LogEntryBuilder builder() {
        return new LogEntryBuilder();
    }

    public LogEntry(long timestamp, UUID actor, String actorName, char type, UUID acted, String actedName, String action) {
        if (actor == null) {
            throw new NullPointerException("actor");
        }
        if (actorName == null) {
            throw new NullPointerException("actorName");
        }
        if (actedName == null) {
            throw new NullPointerException("actedName");
        }
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.timestamp = timestamp;
        this.actor = actor;
        this.actorName = actorName;
        this.type = type;
        this.acted = acted;
        this.actedName = actedName;
        this.action = action;
    }

    protected LogEntry() {
        this.timestamp = 0L;
        this.actor = null;
        this.actorName = null;
        this.type = '\u0000';
        this.acted = null;
        this.actedName = null;
        this.action = null;
    }

    @Override
    public int compareTo(LogEntry o) {
        return this.equals(o) ? 0 : (Long.compare(this.timestamp, o.getTimestamp()) == 0 ? 1 : Long.compare(this.timestamp, o.getTimestamp()));
    }

    public boolean matchesSearch(String query) {
        query = query.toLowerCase();
        return this.actorName.toLowerCase().contains(query) || this.actedName.toLowerCase().contains(query) || this.action.toLowerCase().contains(query);
    }

    public String getFormatted() {
        return String.format(FORMAT, this.actorName, Character.toString(this.type), this.actedName, this.action);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public UUID getActor() {
        return this.actor;
    }

    public String getActorName() {
        return this.actorName;
    }

    public char getType() {
        return this.type;
    }

    public UUID getActed() {
        return this.acted;
    }

    public String getActedName() {
        return this.actedName;
    }

    public String getAction() {
        return this.action;
    }

    void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    void setActor(UUID actor) {
        this.actor = actor;
    }

    void setActorName(String actorName) {
        this.actorName = actorName;
    }

    void setType(char type) {
        this.type = type;
    }

    void setActed(UUID acted) {
        this.acted = acted;
    }

    void setActedName(String actedName) {
        this.actedName = actedName;
    }

    void setAction(String action) {
        this.action = action;
    }

    public String toString() {
        return "LogEntry(timestamp=" + this.getTimestamp() + ", actor=" + this.getActor() + ", actorName=" + this.getActorName() + ", type=" + this.getType() + ", acted=" + this.getActed() + ", actedName=" + this.getActedName() + ", action=" + this.getAction() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEntry)) {
            return false;
        }
        LogEntry other = (LogEntry)o;
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        UUID this$actor = this.getActor();
        UUID other$actor = other.getActor();
        if (this$actor == null ? other$actor != null : !((Object)this$actor).equals(other$actor)) {
            return false;
        }
        String this$actorName = this.getActorName();
        String other$actorName = other.getActorName();
        if (this$actorName == null ? other$actorName != null : !this$actorName.equals(other$actorName)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        UUID this$acted = this.getActed();
        UUID other$acted = other.getActed();
        if (this$acted == null ? other$acted != null : !((Object)this$acted).equals(other$acted)) {
            return false;
        }
        String this$actedName = this.getActedName();
        String other$actedName = other.getActedName();
        if (this$actedName == null ? other$actedName != null : !this$actedName.equals(other$actedName)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        return this$action == null ? other$action == null : this$action.equals(other$action);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        UUID $actor = this.getActor();
        result = result * 59 + ($actor == null ? 43 : ((Object)$actor).hashCode());
        String $actorName = this.getActorName();
        result = result * 59 + ($actorName == null ? 43 : $actorName.hashCode());
        result = result * 59 + this.getType();
        UUID $acted = this.getActed();
        result = result * 59 + ($acted == null ? 43 : ((Object)$acted).hashCode());
        String $actedName = this.getActedName();
        result = result * 59 + ($actedName == null ? 43 : $actedName.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    public static abstract class AbstractLogEntryBuilder<T extends LogEntry, B extends AbstractLogEntryBuilder<T, B>> {
        private T obj = this.createObj();
        private B thisObj = this.getThis();

        protected abstract T createObj();

        protected abstract B getThis();

        public long getTimestamp() {
            return ((LogEntry)this.obj).getTimestamp();
        }

        public UUID getActor() {
            return ((LogEntry)this.obj).getActor();
        }

        public String getActorName() {
            return ((LogEntry)this.obj).getActorName();
        }

        public char getType() {
            return ((LogEntry)this.obj).getType();
        }

        public UUID getActed() {
            return ((LogEntry)this.obj).getActed();
        }

        public String getActedName() {
            return ((LogEntry)this.obj).getActedName();
        }

        public String getAction() {
            return ((LogEntry)this.obj).getAction();
        }

        public B timestamp(long timestamp) {
            ((LogEntry)this.obj).setTimestamp(timestamp);
            return this.thisObj;
        }

        public B actor(UUID actor) {
            ((LogEntry)this.obj).setActor(actor);
            return this.thisObj;
        }

        public B actorName(String actorName) {
            ((LogEntry)this.obj).setActorName(actorName);
            return this.thisObj;
        }

        public B type(char type) {
            ((LogEntry)this.obj).setType(type);
            return this.thisObj;
        }

        public B acted(UUID acted) {
            ((LogEntry)this.obj).setActed(acted);
            return this.thisObj;
        }

        public B actedName(String actedName) {
            ((LogEntry)this.obj).setActedName(actedName);
            return this.thisObj;
        }

        public B action(String action) {
            ((LogEntry)this.obj).setAction(action);
            return this.thisObj;
        }

        public T build() {
            if (this.getActor() == null) {
                throw new NullPointerException("actor");
            }
            if (this.getActorName() == null) {
                throw new NullPointerException("actorName");
            }
            if (this.getActedName() == null) {
                throw new NullPointerException("actedName");
            }
            if (this.getAction() == null) {
                throw new NullPointerException("action");
            }
            return this.obj;
        }

        public String toString() {
            return "LogEntry.LogEntryBuilder(timestamp=" + this.getTimestamp() + ", actor=" + this.getActor() + ", actorName=" + this.getActorName() + ", type=" + this.getType() + ", acted=" + this.getActed() + ", actedName=" + this.getActedName() + ", action=" + this.getAction() + ")";
        }
    }

    public static class LogEntryBuilder
    extends AbstractLogEntryBuilder<LogEntry, LogEntryBuilder> {
        @Override
        protected LogEntry createObj() {
            return new LogEntry();
        }

        @Override
        protected LogEntryBuilder getThis() {
            return this;
        }
    }
}

