/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.lucko.luckperms.api.context.MutableContextSet;

public class ContextSet {
    final Set<Map.Entry<String, String>> contexts;

    public static ContextSet singleton(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        MutableContextSet set = new MutableContextSet();
        set.add(key, value);
        return set.immutableCopy();
    }

    public static ContextSet fromMap(Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map");
        }
        MutableContextSet set = new MutableContextSet();
        set.addAll(map);
        return set.immutableCopy();
    }

    public static ContextSet fromEntries(Iterable<Map.Entry<String, String>> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable");
        }
        MutableContextSet set = new MutableContextSet();
        set.addAll(iterable);
        return set.immutableCopy();
    }

    public static ContextSet fromSet(ContextSet contextSet) {
        if (contextSet == null) {
            throw new NullPointerException("contextSet");
        }
        MutableContextSet set = new MutableContextSet();
        set.addAll(contextSet.toSet());
        return set.immutableCopy();
    }

    public static ContextSet empty() {
        return new ContextSet();
    }

    public ContextSet() {
        this.contexts = new HashSet<Map.Entry<String, String>>();
    }

    protected ContextSet(Set<Map.Entry<String, String>> contexts) {
        this.contexts = contexts;
    }

    public boolean isImmutable() {
        return true;
    }

    public ContextSet makeImmutable() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<String, String>> toSet() {
        Set<Map.Entry<String, String>> set = this.contexts;
        synchronized (set) {
            return ImmutableSet.copyOf(this.contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> toMap() {
        Set<Map.Entry<String, String>> set = this.contexts;
        synchronized (set) {
            return ImmutableMap.copyOf(this.contexts.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Set<Map.Entry<String, String>> set = this.contexts;
        synchronized (set) {
            for (Map.Entry<String, String> e : this.contexts) {
                if (!e.getKey().equalsIgnoreCase(key)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getValues(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        Set<Map.Entry<String, String>> set = this.contexts;
        synchronized (set) {
            return ImmutableSet.copyOf((Collection)this.contexts.stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).map(Map.Entry::getValue).collect(Collectors.toSet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Set<Map.Entry<String, String>> set = this.contexts;
        synchronized (set) {
            for (Map.Entry<String, String> e : this.contexts) {
                if (!e.getKey().equalsIgnoreCase(key) || !e.getValue().equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIgnoreCase(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Set<Map.Entry<String, String>> set = this.contexts;
        synchronized (set) {
            for (Map.Entry<String, String> e : this.contexts) {
                if (!e.getKey().equalsIgnoreCase(key) || !e.getValue().equalsIgnoreCase(value)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Set<Map.Entry<String, String>> set = this.contexts;
        synchronized (set) {
            return this.contexts.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Set<Map.Entry<String, String>> set = this.contexts;
        synchronized (set) {
            return this.contexts.size();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextSet)) {
            return false;
        }
        ContextSet other = (ContextSet)o;
        Set<Map.Entry<String, String>> thisContexts = this.contexts;
        Set<Map.Entry<String, String>> otherContexts = other.contexts;
        return thisContexts == null ? otherContexts == null : ((Object)thisContexts).equals(otherContexts);
    }

    public int hashCode() {
        return 59 + (this.contexts == null ? 43 : this.contexts.hashCode());
    }

    public String toString() {
        return "ContextSet(contexts=" + this.contexts + ")";
    }
}

