/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.api.context;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import me.lucko.luckperms.api.context.ContextListener;
import me.lucko.luckperms.api.context.IContextCalculator;

public abstract class ContextCalculator<T>
implements IContextCalculator<T> {
    private final List<ContextListener<T>> listeners = new CopyOnWriteArrayList<ContextListener<T>>();

    protected void pushUpdate(T subject, Map.Entry<String, String> before, Map.Entry<String, String> current) {
        if (subject == null) {
            throw new NullPointerException("subject");
        }
        if (before == null) {
            throw new NullPointerException("before");
        }
        if (current == null) {
            throw new NullPointerException("current");
        }
        for (ContextListener<T> listener : this.listeners) {
            try {
                listener.onContextChange(subject, before, current);
            }
            catch (Exception e) {
                System.out.println("Exception whilst passing context change to listener: " + listener);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addListener(ContextListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.add(listener);
    }
}

