/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.BuildableDataComponent;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import io.papermc.paper.registry.set.RegistryKeySet;
import net.kyori.adventure.key.Key;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface Equippable
extends BuildableDataComponent<Equippable, Builder> {
    @Contract(value="_ -> new", pure=true)
    public static Builder equippable(EquipmentSlot slot) {
        return ItemComponentTypesBridge.bridge().equippable(slot);
    }

    @Contract(pure=true)
    public EquipmentSlot slot();

    @Contract(pure=true)
    public Key equipSound();

    @Contract(pure=true)
    public @Nullable Key assetId();

    @Contract(pure=true)
    public @Nullable Key cameraOverlay();

    @Contract(pure=true)
    public @Nullable RegistryKeySet<EntityType> allowedEntities();

    @Contract(pure=true)
    public boolean dispensable();

    @Contract(pure=true)
    public boolean swappable();

    @Contract(pure=true)
    public boolean damageOnHurt();

    @Contract(pure=true)
    public boolean equipOnInteract();

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends DataComponentBuilder<Equippable> {
        @Contract(value="_ -> this", mutates="this")
        public Builder equipSound(Key var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder assetId(@Nullable Key var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder cameraOverlay(@Nullable Key var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder allowedEntities(@Nullable RegistryKeySet<EntityType> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder dispensable(boolean var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder swappable(boolean var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder damageOnHurt(boolean var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder equipOnInteract(boolean var1);
    }
}

