/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.ai;

import java.util.Objects;
import java.util.StringJoiner;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Mob;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class GoalKey<T extends Mob> {
    private final Class<T> entityClass;
    private final NamespacedKey namespacedKey;

    private GoalKey(Class<T> entityClass, NamespacedKey namespacedKey) {
        this.entityClass = entityClass;
        this.namespacedKey = namespacedKey;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public NamespacedKey getNamespacedKey() {
        return this.namespacedKey;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoalKey goalKey = (GoalKey)o;
        return Objects.equals(this.entityClass, goalKey.entityClass) && Objects.equals(this.namespacedKey, goalKey.namespacedKey);
    }

    public int hashCode() {
        return Objects.hash(this.entityClass, this.namespacedKey);
    }

    public String toString() {
        return new StringJoiner(", ", GoalKey.class.getSimpleName() + "[", "]").add("entityClass=" + String.valueOf(this.entityClass)).add("namespacedKey=" + String.valueOf(this.namespacedKey)).toString();
    }

    public static <A extends Mob> GoalKey<A> of(Class<A> entityClass, NamespacedKey namespacedKey) {
        return new GoalKey<A>(entityClass, namespacedKey);
    }
}

