/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import java.net.InetAddress;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class PlayerLoginEvent
extends PlayerEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final String hostname;
    private final InetAddress address;
    private final InetAddress realAddress;
    private Result result = Result.ALLOWED;
    private Component message = Component.empty();

    @ApiStatus.Internal
    public PlayerLoginEvent(@NotNull Player player, @NotNull String hostname, @NotNull InetAddress address, @NotNull InetAddress realAddress) {
        super(player);
        this.hostname = hostname;
        this.address = address;
        this.realAddress = realAddress;
    }

    @ApiStatus.Internal
    public PlayerLoginEvent(@NotNull Player player, @NotNull String hostname, @NotNull InetAddress address) {
        this(player, hostname, address, address);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public PlayerLoginEvent(@NotNull Player player, @NotNull String hostname, @NotNull InetAddress address, @NotNull Result result, @NotNull String message, @NotNull InetAddress realAddress) {
        this(player, hostname, address, realAddress);
        this.result = result;
        this.message = LegacyComponentSerializer.legacySection().deserialize(message);
    }

    @ApiStatus.Internal
    public PlayerLoginEvent(@NotNull Player player, @NotNull String hostname, @NotNull InetAddress address, @NotNull Result result, @NotNull Component message, @NotNull InetAddress realAddress) {
        this(player, hostname, address, realAddress);
        this.result = result;
        this.message = message;
    }

    @NotNull
    public String getHostname() {
        return this.hostname;
    }

    @NotNull
    public InetAddress getAddress() {
        return this.address;
    }

    @NotNull
    public InetAddress getRealAddress() {
        return this.realAddress;
    }

    @NotNull
    public Result getResult() {
        return this.result;
    }

    public void setResult(@NotNull Result result) {
        this.result = result;
    }

    @NotNull
    public Component kickMessage() {
        return this.message;
    }

    public void kickMessage(@NotNull Component message) {
        this.message = message;
    }

    @Deprecated
    @NotNull
    public String getKickMessage() {
        return LegacyComponentSerializer.legacySection().serialize(this.message);
    }

    @Deprecated
    public void setKickMessage(@NotNull String message) {
        this.message = LegacyComponentSerializer.legacySection().deserialize(message);
    }

    public void allow() {
        this.result = Result.ALLOWED;
        this.message = Component.empty();
    }

    @Deprecated
    public void disallow(@NotNull Result result, @NotNull String message) {
        this.result = result;
        this.message = LegacyComponentSerializer.legacySection().deserialize(message);
    }

    public void disallow(@NotNull Result result, @NotNull Component message) {
        this.result = result;
        this.message = message;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum Result {
        ALLOWED,
        KICK_FULL,
        KICK_BANNED,
        KICK_WHITELIST,
        KICK_OTHER;

    }
}

