/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import java.util.List;
import org.bukkit.Color;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface CustomModelData {
    @Contract(value="-> new", pure=true)
    public static Builder customModelData() {
        return ItemComponentTypesBridge.bridge().customModelData();
    }

    @Contract(pure=true)
    public @Unmodifiable List<Float> floats();

    @Contract(pure=true)
    public @Unmodifiable List<Boolean> flags();

    @Contract(pure=true)
    public @Unmodifiable List<String> strings();

    @Contract(pure=true)
    public @Unmodifiable List<Color> colors();

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends DataComponentBuilder<CustomModelData> {
        @Contract(value="_ -> this", mutates="this")
        public Builder addFloat(float var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addFloats(List<Float> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addFlag(boolean var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addFlags(List<Boolean> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addString(String var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addStrings(List<String> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addColor(Color var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addColors(List<Color> var1);
    }
}

