/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.inventory;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class FurnaceExtractEvent
extends BlockExpEvent {
    private final Player player;
    private final Material itemType;
    private final int itemAmount;

    @ApiStatus.Internal
    public FurnaceExtractEvent(@NotNull Player player, @NotNull Block block, @NotNull Material itemType, int itemAmount, int exp) {
        super(block, exp);
        this.player = player;
        if (itemType != null && itemType.isLegacy()) {
            itemType = Bukkit.getUnsafe().fromLegacy(new MaterialData(itemType), true);
        }
        this.itemType = itemType;
        this.itemAmount = itemAmount;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Material getItemType() {
        return this.itemType;
    }

    public int getItemAmount() {
        return this.itemAmount;
    }
}

