/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import java.util.Map;
import org.bukkit.map.MapCursor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface MapDecorations {
    @Contract(value="_ -> new", pure=true)
    public static MapDecorations mapDecorations(Map<String, DecorationEntry> entries) {
        return (MapDecorations)MapDecorations.mapDecorations().putAll(entries).build();
    }

    @Contract(value="-> new", pure=true)
    public static Builder mapDecorations() {
        return ItemComponentTypesBridge.bridge().mapDecorations();
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static DecorationEntry decorationEntry(MapCursor.Type type, double x, double z, float rotation) {
        return ItemComponentTypesBridge.bridge().decorationEntry(type, x, z, rotation);
    }

    @Contract(pure=true)
    public @Nullable DecorationEntry decoration(String var1);

    @Contract(pure=true)
    public @Unmodifiable Map<String, DecorationEntry> decorations();

    @ApiStatus.NonExtendable
    @ApiStatus.Experimental
    public static interface Builder
    extends DataComponentBuilder<MapDecorations> {
        @Contract(value="_, _ -> this", mutates="this")
        public Builder put(String var1, DecorationEntry var2);

        @Contract(value="_ -> this", mutates="this")
        public Builder putAll(Map<String, DecorationEntry> var1);
    }

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface DecorationEntry {
        @Contract(pure=true)
        public MapCursor.Type type();

        @Contract(pure=true)
        public double x();

        @Contract(pure=true)
        public double z();

        @Contract(pure=true)
        public float rotation();
    }
}

