/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.inventory;

import net.kyori.adventure.text.Component;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum InventoryType {
    CHEST(27, "Chest", MenuType.GENERIC_9X3),
    DISPENSER(9, "Dispenser", MenuType.GENERIC_3X3),
    DROPPER(9, "Dropper", MenuType.GENERIC_3X3),
    FURNACE(3, "Furnace", MenuType.FURNACE),
    WORKBENCH(10, "Crafting", MenuType.CRAFTING),
    CRAFTING(5, "Crafting", null, false),
    ENCHANTING(2, "Enchanting", MenuType.ENCHANTMENT),
    BREWING(5, "Brewing", MenuType.BREWING_STAND),
    PLAYER(43, "Player", MenuType.GENERIC_9X4),
    CREATIVE(9, "Creative", null, false),
    MERCHANT(3, "Villager", MenuType.MERCHANT, false),
    ENDER_CHEST(27, "Ender Chest", MenuType.GENERIC_9X3),
    ANVIL(3, "Repairing", MenuType.ANVIL),
    SMITHING(4, "Upgrade Gear", MenuType.SMITHING),
    BEACON(1, "container.beacon", MenuType.BEACON),
    HOPPER(5, "Item Hopper", MenuType.HOPPER),
    SHULKER_BOX(27, "Shulker Box", MenuType.SHULKER_BOX),
    BARREL(27, "Barrel", MenuType.GENERIC_9X3),
    BLAST_FURNACE(3, "Blast Furnace", MenuType.BLAST_FURNACE),
    LECTERN(1, "Lectern", MenuType.LECTERN),
    SMOKER(3, "Smoker", MenuType.SMOKER),
    LOOM(4, "Loom", MenuType.LOOM),
    CARTOGRAPHY(3, "Cartography Table", MenuType.CARTOGRAPHY_TABLE),
    GRINDSTONE(3, "Repair & Disenchant", MenuType.GRINDSTONE),
    STONECUTTER(2, "Stonecutter", MenuType.STONECUTTER),
    COMPOSTER(1, "Composter", null, false),
    CHISELED_BOOKSHELF(6, "Chiseled Bookshelf", null, false),
    SHELF(3, "Shelf", null, false),
    JUKEBOX(1, "Jukebox", null, false),
    DECORATED_POT(1, "Decorated Pot", null, false),
    CRAFTER(9, "Crafter", MenuType.CRAFTER_3X3),
    SMITHING_NEW(4, "Upgrade Gear", MenuType.SMITHING);

    private final int size;
    private final String title;
    private final MenuType menuType;
    private final boolean isCreatable;
    private final Component defaultTitleComponent;

    public @NotNull Component defaultTitle() {
        return this.defaultTitleComponent;
    }

    private InventoryType(@Nullable int defaultSize, String defaultTitle, MenuType type) {
        this(defaultSize, defaultTitle, type, true);
    }

    private InventoryType(@Nullable int defaultSize, String defaultTitle, MenuType type, boolean isCreatable) {
        this.size = defaultSize;
        this.title = defaultTitle;
        this.menuType = type;
        this.isCreatable = isCreatable;
        this.defaultTitleComponent = Component.text((String)defaultTitle);
    }

    public int getDefaultSize() {
        return this.size;
    }

    @Deprecated
    @NotNull
    public String getDefaultTitle() {
        return this.title;
    }

    @Nullable
    public MenuType getMenuType() {
        return this.menuType;
    }

    public boolean isCreatable() {
        return this.isCreatable;
    }

    public static enum SlotType {
        RESULT,
        CRAFTING,
        ARMOR,
        CONTAINER,
        QUICKBAR,
        OUTSIDE,
        FUEL;

    }
}

