/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;

public class ShapedRecipe
extends CraftingRecipe {
    private String[] rows;
    private Map<Character, RecipeChoice> ingredients = new HashMap<Character, RecipeChoice>();

    @Deprecated
    public ShapedRecipe(@NotNull ItemStack result) {
        this(NamespacedKey.randomKey(), result);
        new Throwable("Warning: A plugin is creating a recipe using a Deprecated method. This will cause you to receive warnings stating 'Tried to load unrecognized recipe: bukkit:<ID>'. Please ask the author to give their recipe a static key using NamespacedKey.").printStackTrace();
    }

    public ShapedRecipe(@NotNull NamespacedKey key, @NotNull ItemStack result) {
        super(key, ShapedRecipe.checkResult(result));
    }

    @NotNull
    public ShapedRecipe shape(String ... shape) {
        Preconditions.checkArgument((shape != null ? 1 : 0) != 0, (Object)"Must provide a shape");
        Preconditions.checkArgument((shape.length > 0 && shape.length < 4 ? 1 : 0) != 0, (String)"Crafting recipes should be 1, 2 or 3 rows, not ", (int)shape.length);
        int lastLen = -1;
        for (String row : shape) {
            Preconditions.checkArgument((row != null ? 1 : 0) != 0, (Object)"Shape cannot have null rows");
            Preconditions.checkArgument((row.length() > 0 && row.length() < 4 ? 1 : 0) != 0, (String)"Crafting rows should be 1, 2, or 3 characters, not ", (int)row.length());
            Preconditions.checkArgument((lastLen == -1 || lastLen == row.length() ? 1 : 0) != 0, (Object)"Crafting recipes must be rectangular");
            lastLen = row.length();
        }
        this.rows = new String[shape.length];
        for (int i = 0; i < shape.length; ++i) {
            this.rows[i] = shape[i];
        }
        HashMap<Character, RecipeChoice> newIngredients = new HashMap<Character, RecipeChoice>();
        for (String row : shape) {
            for (char c : row.toCharArray()) {
                if (c == ' ') continue;
                newIngredients.put(Character.valueOf(c), this.ingredients.get(Character.valueOf(c)));
            }
        }
        this.ingredients = newIngredients;
        return this;
    }

    @Deprecated
    @NotNull
    public ShapedRecipe setIngredient(char key, @NotNull MaterialData ingredient) {
        return this.setIngredient(key, ingredient.getItemType(), ingredient.getData());
    }

    @NotNull
    public ShapedRecipe setIngredient(char key, @NotNull Material ingredient) {
        return this.setIngredient(key, ingredient, 0);
    }

    @Deprecated
    @NotNull
    public ShapedRecipe setIngredient(char key, @NotNull Material ingredient, int raw) {
        Preconditions.checkArgument((key != ' ' ? 1 : 0) != 0, (Object)"Space in recipe shape must represent no ingredient");
        Preconditions.checkArgument((boolean)this.ingredients.containsKey(Character.valueOf(key)), (String)"Symbol does not appear in the shape:", (char)key);
        if (raw == -1) {
            raw = Short.MAX_VALUE;
        }
        this.ingredients.put(Character.valueOf(key), new RecipeChoice.MaterialChoice(Collections.singletonList(ingredient)));
        return this;
    }

    @NotNull
    public ShapedRecipe setIngredient(char key, @NotNull RecipeChoice ingredient) {
        Preconditions.checkArgument((key != ' ' ? 1 : 0) != 0, (Object)"Space in recipe shape must represent no ingredient");
        Preconditions.checkArgument((boolean)this.ingredients.containsKey(Character.valueOf(key)), (String)"Symbol does not appear in the shape:", (char)key);
        this.ingredients.put(Character.valueOf(key), ingredient.validate(false).clone());
        return this;
    }

    @NotNull
    public ShapedRecipe setIngredient(char key, @NotNull ItemStack item) {
        Preconditions.checkArgument((!item.getType().isAir() ? 1 : 0) != 0, (Object)"Item cannot be air");
        return this.setIngredient(key, new RecipeChoice.ExactChoice(item.clone()));
    }

    @Deprecated
    @NotNull
    public Map<Character, ItemStack> getIngredientMap() {
        HashMap<Character, ItemStack> result = new HashMap<Character, ItemStack>();
        for (Map.Entry<Character, RecipeChoice> ingredient : this.ingredients.entrySet()) {
            if (ingredient.getValue() == null) {
                result.put(ingredient.getKey(), null);
                continue;
            }
            result.put(ingredient.getKey(), ingredient.getValue().getItemStack().clone());
        }
        return result;
    }

    @NotNull
    public Map<Character, RecipeChoice> getChoiceMap() {
        HashMap<Character, RecipeChoice> result = new HashMap<Character, RecipeChoice>();
        for (Map.Entry<Character, RecipeChoice> ingredient : this.ingredients.entrySet()) {
            if (ingredient.getValue() == null) {
                result.put(ingredient.getKey(), null);
                continue;
            }
            result.put(ingredient.getKey(), ingredient.getValue().clone());
        }
        return result;
    }

    @NotNull
    public String[] getShape() {
        return (String[])this.rows.clone();
    }
}

