/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.unix.Buffer;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.Native;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.StringJoiner;

final class SubmissionQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SubmissionQueue.class);
    static final int SQE_SIZE = 64;
    private static final int SQE_OP_CODE_FIELD = 0;
    private static final int SQE_FLAGS_FIELD = 1;
    private static final int SQE_IOPRIO_FIELD = 2;
    private static final int SQE_FD_FIELD = 4;
    private static final int SQE_UNION1_FIELD = 8;
    private static final int SQE_UNION2_FIELD = 16;
    private static final int SQE_LEN_FIELD = 24;
    private static final int SQE_UNION3_FIELD = 28;
    private static final int SQE_USER_DATA_FIELD = 32;
    private static final int SQE_UNION4_FIELD = 40;
    private static final int SQE_PERSONALITY_FIELD = 42;
    private static final int SQE_UNION5_FIELD = 44;
    private static final int SQE_UNION6_FIELD = 48;
    private static final VarHandle INT_HANDLE = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.nativeOrder());
    private final ByteBuffer kHead;
    private final ByteBuffer kTail;
    private final ByteBuffer submissionQueueArray;
    final int ringEntries;
    private final int ringMask;
    final int ringSize;
    final long ringAddress;
    final int ringFd;
    int enterRingFd;
    private int enterFlags;
    private int head;
    private int tail;
    private boolean closed;

    SubmissionQueue(ByteBuffer khead, ByteBuffer ktail, int ringMask, int ringEntries, ByteBuffer submissionQueueArray, int ringSize, long ringAddress, int ringFd) {
        this.kHead = khead;
        this.kTail = ktail;
        this.submissionQueueArray = submissionQueueArray;
        this.ringSize = ringSize;
        this.ringAddress = ringAddress;
        this.ringFd = ringFd;
        this.enterRingFd = ringFd;
        this.ringEntries = ringEntries;
        this.ringMask = ringMask;
        this.head = INT_HANDLE.getVolatile(khead, 0);
        this.tail = INT_HANDLE.getVolatile(ktail, 0);
    }

    long submissionQueueArrayAddress() {
        return Buffer.memoryAddress((ByteBuffer)this.submissionQueueArray);
    }

    void close() {
        this.closed = true;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    void tryRegisterRingFd() {
        int enterFlags;
        this.checkClosed();
        int enterRingFd = Native.ioUringRegisterRingFds(this.ringFd);
        if (enterRingFd < 0) {
            enterRingFd = this.ringFd;
            enterFlags = 0;
        } else {
            enterFlags = 16;
        }
        this.enterRingFd = enterRingFd;
        this.enterFlags = enterFlags;
    }

    long enqueueSqe(byte opcode, byte flags, short ioPrio, int fd, long union1, long union2, int len, int union3, long udata, short union4, short personality, int union5, long union6) {
        int submitted;
        this.checkClosed();
        int pending = this.tail - this.head;
        if (pending == this.ringEntries && (submitted = this.submit()) == 0) {
            throw new RuntimeException("SQ ring full and no submissions accepted");
        }
        int sqe = SubmissionQueue.sqeIndex(this.tail++, this.ringMask);
        this.submissionQueueArray.put(sqe + 0, opcode);
        this.submissionQueueArray.put(sqe + 1, flags);
        this.submissionQueueArray.putShort(sqe + 2, ioPrio);
        this.submissionQueueArray.putInt(sqe + 4, fd);
        this.submissionQueueArray.putLong(sqe + 8, union1);
        this.submissionQueueArray.putLong(sqe + 16, union2);
        this.submissionQueueArray.putInt(sqe + 24, len);
        this.submissionQueueArray.putInt(sqe + 28, union3);
        this.submissionQueueArray.putLong(sqe + 32, udata);
        this.submissionQueueArray.putShort(sqe + 40, union4);
        this.submissionQueueArray.putShort(sqe + 42, personality);
        this.submissionQueueArray.putInt(sqe + 44, union5);
        this.submissionQueueArray.putLong(sqe + 48, union6);
        if (logger.isTraceEnabled()) {
            if (opcode == 2 || opcode == 1) {
                logger.trace("add(ring={}, enterRing:{} ): {}(fd={}, len={}, off={}, data={})", new Object[]{this.ringFd, this.enterRingFd, Native.opToStr(opcode), fd, len, union1, udata});
            } else {
                logger.trace("add(ring={}, enterRing:{}): {}(fd={}, len={}, off={}, data={})", new Object[]{this.ringFd, this.enterRingFd, Native.opToStr(opcode), fd, len, union1, udata});
            }
        }
        return udata;
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(", ", "SubmissionQueue [", "]");
        if (this.closed) {
            sb.add("closed");
        } else {
            int pending = this.tail - this.head;
            int idx = this.tail;
            for (int i = 0; i < pending; ++i) {
                int sqe = SubmissionQueue.sqeIndex(idx++, this.ringMask);
                sb.add(Native.opToStr(this.submissionQueueArray.get(sqe + 0)) + "(fd=" + this.submissionQueueArray.getInt(sqe + 4) + ")");
            }
        }
        return sb.toString();
    }

    private static int sqeIndex(int tail, int ringMask) {
        return (tail & ringMask) * 64;
    }

    long addNop(byte flags, long udata) {
        return this.enqueueSqe((byte)0, flags, (short)0, -1, 0L, 0L, 0, 0, udata, (short)0, (short)0, 0, 0L);
    }

    long addTimeout(long timeoutMemoryAddress, long udata) {
        return this.enqueueSqe((byte)11, (byte)0, (short)0, -1, 1L, timeoutMemoryAddress, 1, 0, udata, (short)0, (short)0, 0, 0L);
    }

    long addLinkTimeout(long timeoutMemoryAddress, long extraData) {
        return this.enqueueSqe((byte)15, (byte)0, (short)0, -1, 1L, timeoutMemoryAddress, 1, 0, extraData, (short)0, (short)0, 0, 0L);
    }

    long addEventFdRead(int fd, long bufferAddress, int pos, int limit, long udata) {
        return this.enqueueSqe((byte)22, (byte)0, (short)0, fd, 0L, bufferAddress + (long)pos, limit - pos, 0, udata, (short)0, (short)0, 0, 0L);
    }

    long addCancel(long sqeToCancel, long udata) {
        return this.enqueueSqe((byte)14, (byte)0, (short)0, -1, 0L, sqeToCancel, 0, 0, udata, (short)0, (short)0, 0, 0L);
    }

    int submit() {
        this.checkClosed();
        int submit = this.tail - this.head;
        return submit > 0 ? this.submit(submit, 0, 0) : 0;
    }

    int submitAndGet() {
        return this.submitAndGet0(1);
    }

    int submitAndGetNow() {
        return this.submitAndGet0(0);
    }

    private int submitAndGet0(int minComplete) {
        this.checkClosed();
        int submit = this.tail - this.head;
        if (submit > 0) {
            return this.submit(submit, minComplete, Native.IORING_ENTER_GETEVENTS);
        }
        assert (submit == 0);
        int ret = this.ioUringEnter(0, minComplete, Native.IORING_ENTER_GETEVENTS);
        if (ret < 0) {
            throw new RuntimeException("ioUringEnter syscall returned " + ret);
        }
        return ret;
    }

    private int submit(int toSubmit, int minComplete, int flags) {
        INT_HANDLE.setRelease(this.kTail, 0, this.tail);
        int ret = this.ioUringEnter(toSubmit, minComplete, flags);
        this.head = INT_HANDLE.getVolatile(this.kHead, 0);
        if (ret != toSubmit && ret < 0) {
            throw new RuntimeException("ioUringEnter syscall returned " + ret);
        }
        return ret;
    }

    private int ioUringEnter(int toSubmit, int minComplete, int flags) {
        int f = this.enterFlags | flags;
        if (IoUring.isSetupSubmitAllSupported()) {
            return this.ioUringEnter0(toSubmit, minComplete, f);
        }
        int submitted = 0;
        int ret;
        while ((ret = this.ioUringEnter0(toSubmit, minComplete, f)) >= 0) {
            submitted += ret;
            if (ret == toSubmit) {
                return submitted;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Not all submissions succeeded. Only {} of {} SQEs were submitted.", (Object)ret, (Object)toSubmit);
            }
            toSubmit -= ret;
        }
        return ret;
    }

    private int ioUringEnter0(int toSubmit, int minComplete, int f) {
        if (logger.isTraceEnabled()) {
            logger.trace("io_uring_enter(ring={}, enterRing={}, toSubmit={}, minComplete={}, flags={}): {}", new Object[]{this.ringFd, this.enterRingFd, toSubmit, minComplete, f, this.toString()});
        }
        return Native.ioUringEnter(this.enterRingFd, toSubmit, minComplete, f);
    }

    public int count() {
        return this.tail - this.head;
    }

    public int remaining() {
        return this.ringEntries - this.count();
    }
}

