/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.session;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonArray;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonBinary;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocumentWriter;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonWriter;
import io.github.apfelcreme.SupportTickets.lib.bson.UuidRepresentation;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonDocumentCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.EncoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.UuidCodec;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ReadPreference;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerApi;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ServerDescription;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.IgnorableRequestContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.ReferenceCounted;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.Cluster;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.NoOpSessionContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.selector.ReadPreferenceServerSelector;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.validator.NoOpFieldNameValidator;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import io.github.apfelcreme.SupportTickets.lib.mongodb.session.ServerSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class ServerSessionPool {
    private final ConcurrentLinkedDeque<ServerSessionImpl> available = new ConcurrentLinkedDeque();
    private final Cluster cluster;
    private final Clock clock;
    private volatile boolean closed;
    @Nullable
    private final ServerApi serverApi;
    private final LongAdder inUseCount = new LongAdder();

    public ServerSessionPool(Cluster cluster, @Nullable ServerApi serverApi) {
        this(cluster, serverApi, System::currentTimeMillis);
    }

    public ServerSessionPool(Cluster cluster, @Nullable ServerApi serverApi, Clock clock) {
        this.cluster = cluster;
        this.serverApi = serverApi;
        this.clock = clock;
    }

    public ServerSession get() {
        Assertions.isTrue("server session pool is open", !this.closed);
        ServerSessionImpl serverSession = this.available.pollLast();
        while (serverSession != null && this.shouldPrune(serverSession)) {
            serverSession.close();
            serverSession = this.available.pollLast();
        }
        if (serverSession == null) {
            serverSession = new ServerSessionImpl();
        }
        this.inUseCount.increment();
        return serverSession;
    }

    public void release(ServerSession serverSession) {
        this.inUseCount.decrement();
        ServerSessionImpl serverSessionImpl = (ServerSessionImpl)serverSession;
        if (serverSessionImpl.isMarkedDirty()) {
            serverSessionImpl.close();
        } else {
            this.available.addLast(serverSessionImpl);
        }
    }

    public long getInUseCount() {
        return this.inUseCount.sum();
    }

    public void close() {
        this.closed = true;
        this.endClosedSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endClosedSessions() {
        List<BsonDocument> identifiers = this.drainPool();
        if (identifiers.isEmpty()) {
            return;
        }
        List<ServerDescription> primaryPreferred = new ReadPreferenceServerSelector(ReadPreference.primaryPreferred()).select(this.cluster.getCurrentDescription());
        if (primaryPreferred.isEmpty()) {
            return;
        }
        ReferenceCounted connection = null;
        try {
            connection = this.cluster.selectServer(clusterDescription -> {
                for (ServerDescription cur : clusterDescription.getServerDescriptions()) {
                    if (!cur.getAddress().equals(((ServerDescription)primaryPreferred.get(0)).getAddress())) continue;
                    return Collections.singletonList(cur);
                }
                return Collections.emptyList();
            }).getServer().getConnection();
            connection.command("admin", new BsonDocument("endSessions", new BsonArray(identifiers)), new NoOpFieldNameValidator(), ReadPreference.primaryPreferred(), new BsonDocumentCodec(), NoOpSessionContext.INSTANCE, this.serverApi, IgnorableRequestContext.INSTANCE);
        }
        catch (MongoException mongoException) {
        }
        finally {
            if (connection != null) {
                connection.release();
            }
        }
    }

    private List<BsonDocument> drainPool() {
        ArrayList<BsonDocument> identifiers = new ArrayList<BsonDocument>(this.available.size());
        ServerSessionImpl nextSession = this.available.pollFirst();
        while (nextSession != null) {
            identifiers.add(nextSession.getIdentifier());
            nextSession = this.available.pollFirst();
        }
        return identifiers;
    }

    private boolean shouldPrune(ServerSessionImpl serverSession) {
        long oneMinuteFromTimeout;
        Integer logicalSessionTimeoutMinutes = this.cluster.getCurrentDescription().getLogicalSessionTimeoutMinutes();
        if (logicalSessionTimeoutMinutes == null) {
            return false;
        }
        long currentTimeMillis = this.clock.millis();
        long timeSinceLastUse = currentTimeMillis - serverSession.getLastUsedAtMillis();
        return timeSinceLastUse > (oneMinuteFromTimeout = TimeUnit.MINUTES.toMillis(logicalSessionTimeoutMinutes - 1));
    }

    private BsonBinary createNewServerSessionIdentifier() {
        UuidCodec uuidCodec = new UuidCodec(UuidRepresentation.STANDARD);
        BsonDocument holder = new BsonDocument();
        BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(holder);
        bsonDocumentWriter.writeStartDocument();
        bsonDocumentWriter.writeName("id");
        uuidCodec.encode((BsonWriter)bsonDocumentWriter, UUID.randomUUID(), EncoderContext.builder().build());
        bsonDocumentWriter.writeEndDocument();
        return holder.getBinary("id");
    }

    static interface Clock {
        public long millis();
    }

    final class ServerSessionImpl
    implements ServerSession {
        private final BsonDocument identifier;
        private long transactionNumber = 0L;
        private volatile long lastUsedAtMillis = ServerSessionPool.access$000(ServerSessionPool.this).millis();
        private volatile boolean closed;
        private volatile boolean dirty = false;

        ServerSessionImpl() {
            this.identifier = new BsonDocument("id", ServerSessionPool.this.createNewServerSessionIdentifier());
        }

        void close() {
            this.closed = true;
        }

        long getLastUsedAtMillis() {
            return this.lastUsedAtMillis;
        }

        @Override
        public long getTransactionNumber() {
            return this.transactionNumber;
        }

        @Override
        public BsonDocument getIdentifier() {
            this.lastUsedAtMillis = ServerSessionPool.this.clock.millis();
            return this.identifier;
        }

        @Override
        public long advanceTransactionNumber() {
            ++this.transactionNumber;
            return this.transactionNumber;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void markDirty() {
            this.dirty = true;
        }

        @Override
        public boolean isMarkedDirty() {
            return this.dirty;
        }
    }
}

