/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.selector;

import io.github.apfelcreme.SupportTickets.lib.mongodb.ReadPreference;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterConnectionMode;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterDescription;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ServerDescription;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ClusterDescriptionHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.selector.ServerSelector;
import java.util.List;

public class ReadPreferenceServerSelector
implements ServerSelector {
    private final ReadPreference readPreference;

    public ReadPreferenceServerSelector(ReadPreference readPreference) {
        this.readPreference = Assertions.notNull("readPreference", readPreference);
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return ClusterDescriptionHelper.getAny(clusterDescription);
        }
        return this.readPreference.choose(clusterDescription);
    }

    public String toString() {
        return "ReadPreferenceServerSelector{readPreference=" + this.readPreference + '}';
    }
}

