/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonTimestamp;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Decoder;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistry;
import io.github.apfelcreme.SupportTickets.lib.bson.conversions.Bson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.AutoEncryptionSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoNamespace;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ReadConcern;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ReadPreference;
import io.github.apfelcreme.SupportTickets.lib.mongodb.WriteConcern;
import io.github.apfelcreme.SupportTickets.lib.mongodb.bulk.BulkWriteResult;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.BulkWriteOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.Collation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.CountOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.CreateCollectionOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.CreateIndexOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.CreateViewOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.DeleteOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.DropCollectionOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.DropIndexOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.EstimatedDocumentCountOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.FindOneAndDeleteOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.FindOneAndReplaceOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.FindOneAndUpdateOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.IndexModel;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.InsertManyOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.InsertOneOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.MapReduceAction;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.RenameCollectionOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.ReplaceOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.UpdateOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.WriteModel;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.changestream.FullDocument;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.changestream.FullDocumentBeforeChange;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.client.model.AggregationLevel;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.client.model.FindOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.BatchCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.ExplainableReadOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.MapReduceBatchCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.MapReduceStatistics;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.Operations;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.ReadOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.WriteOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.List;

public final class SyncOperations<TDocument> {
    private final Operations<TDocument> operations;

    public SyncOperations(Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, boolean retryReads) {
        this(null, documentClass, readPreference, codecRegistry, ReadConcern.DEFAULT, WriteConcern.ACKNOWLEDGED, true, retryReads);
    }

    public SyncOperations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, boolean retryReads) {
        this(namespace, documentClass, readPreference, codecRegistry, ReadConcern.DEFAULT, WriteConcern.ACKNOWLEDGED, true, retryReads);
    }

    public SyncOperations(@Nullable MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads) {
        this.operations = new Operations<TDocument>(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcern, retryWrites, retryReads);
    }

    public ReadOperation<Long> countDocuments(Bson filter, CountOptions options) {
        return this.operations.countDocuments(filter, options);
    }

    public ReadOperation<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.operations.estimatedDocumentCount(options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> findFirst(Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.findFirst(filter, resultClass, options);
    }

    public <TResult> ExplainableReadOperation<BatchCursor<TResult>> find(Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(filter, resultClass, options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> find(MongoNamespace findNamespace, Bson filter, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(findNamespace, filter, resultClass, options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> distinct(String fieldName, Bson filter, Class<TResult> resultClass, long maxTimeMS, Collation collation, BsonValue comment) {
        return this.operations.distinct(fieldName, filter, resultClass, maxTimeMS, collation, comment);
    }

    public <TResult> ExplainableReadOperation<BatchCursor<TResult>> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass, long maxTimeMS, long maxAwaitTimeMS, @Nullable Integer batchSize, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, Boolean allowDiskUse, AggregationLevel aggregationLevel) {
        return this.operations.aggregate(pipeline, resultClass, maxTimeMS, maxAwaitTimeMS, batchSize, collation, hint, hintString, comment, variables, allowDiskUse, aggregationLevel);
    }

    public ReadOperation<Void> aggregateToCollection(List<? extends Bson> pipeline, long maxTimeMS, Boolean allowDiskUse, Boolean bypassDocumentValidation, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, AggregationLevel aggregationLevel) {
        return this.operations.aggregateToCollection(pipeline, maxTimeMS, allowDiskUse, bypassDocumentValidation, collation, hint, hintString, comment, variables, aggregationLevel);
    }

    public WriteOperation<MapReduceStatistics> mapReduceToCollection(String databaseName, String collectionName, String mapFunction, String reduceFunction, String finalizeFunction, Bson filter, int limit, long maxTimeMS, boolean jsMode, Bson scope, Bson sort, boolean verbose, MapReduceAction action, boolean nonAtomic, boolean sharded, Boolean bypassDocumentValidation, Collation collation) {
        return this.operations.mapReduceToCollection(databaseName, collectionName, mapFunction, reduceFunction, finalizeFunction, filter, limit, maxTimeMS, jsMode, scope, sort, verbose, action, nonAtomic, sharded, bypassDocumentValidation, collation);
    }

    public <TResult> ReadOperation<MapReduceBatchCursor<TResult>> mapReduce(String mapFunction, String reduceFunction, String finalizeFunction, Class<TResult> resultClass, Bson filter, int limit, long maxTimeMS, boolean jsMode, Bson scope, Bson sort, boolean verbose, Collation collation) {
        return this.operations.mapReduce(mapFunction, reduceFunction, finalizeFunction, resultClass, filter, limit, maxTimeMS, jsMode, scope, sort, verbose, collation);
    }

    public WriteOperation<TDocument> findOneAndDelete(Bson filter, FindOneAndDeleteOptions options) {
        return this.operations.findOneAndDelete(filter, options);
    }

    public WriteOperation<TDocument> findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options) {
        return this.operations.findOneAndReplace(filter, replacement, options);
    }

    public WriteOperation<TDocument> findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter, update, options);
    }

    public WriteOperation<TDocument> findOneAndUpdate(Bson filter, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter, update, options);
    }

    public WriteOperation<BulkWriteResult> insertOne(TDocument document, InsertOneOptions options) {
        return this.operations.insertOne(document, options);
    }

    public WriteOperation<BulkWriteResult> replaceOne(Bson filter, TDocument replacement, ReplaceOptions options) {
        return this.operations.replaceOne(filter, replacement, options);
    }

    public WriteOperation<BulkWriteResult> deleteOne(Bson filter, DeleteOptions options) {
        return this.operations.deleteOne(filter, options);
    }

    public WriteOperation<BulkWriteResult> deleteMany(Bson filter, DeleteOptions options) {
        return this.operations.deleteMany(filter, options);
    }

    public WriteOperation<BulkWriteResult> updateOne(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateOne(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateMany(Bson filter, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateMany(Bson filter, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> insertMany(List<? extends TDocument> documents, InsertManyOptions options) {
        return this.operations.insertMany(documents, options);
    }

    public WriteOperation<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.operations.bulkWrite(requests, options);
    }

    public <TResult> ReadOperation<TResult> commandRead(Bson command, Class<TResult> resultClass) {
        return this.operations.commandRead(command, resultClass);
    }

    public WriteOperation<Void> dropDatabase() {
        return this.operations.dropDatabase();
    }

    public WriteOperation<Void> createCollection(String collectionName, CreateCollectionOptions createCollectionOptions, @Nullable AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.createCollection(collectionName, createCollectionOptions, autoEncryptionSettings);
    }

    public WriteOperation<Void> dropCollection(DropCollectionOptions dropCollectionOptions, @Nullable AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.dropCollection(dropCollectionOptions, autoEncryptionSettings);
    }

    public WriteOperation<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.operations.renameCollection(newCollectionNamespace, options);
    }

    public WriteOperation<Void> createView(String viewName, String viewOn, List<? extends Bson> pipeline, CreateViewOptions createViewOptions) {
        return this.operations.createView(viewName, viewOn, pipeline, createViewOptions);
    }

    public WriteOperation<Void> createIndexes(List<IndexModel> indexes, CreateIndexOptions options) {
        return this.operations.createIndexes(indexes, options);
    }

    public WriteOperation<Void> dropIndex(String indexName, DropIndexOptions options) {
        return this.operations.dropIndex(indexName, options);
    }

    public WriteOperation<Void> dropIndex(Bson keys, DropIndexOptions options) {
        return this.operations.dropIndex(keys, options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listCollections(String databaseName, Class<TResult> resultClass, Bson filter, boolean collectionNamesOnly, @Nullable Integer batchSize, long maxTimeMS, BsonValue comment) {
        return this.operations.listCollections(databaseName, resultClass, filter, collectionNamesOnly, batchSize, maxTimeMS, comment);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listDatabases(Class<TResult> resultClass, Bson filter, Boolean nameOnly, long maxTimeMS, Boolean authorizedDatabases, BsonValue comment) {
        return this.operations.listDatabases(resultClass, filter, nameOnly, maxTimeMS, authorizedDatabases, comment);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listIndexes(Class<TResult> resultClass, @Nullable Integer batchSize, long maxTimeMS, BsonValue comment) {
        return this.operations.listIndexes(resultClass, batchSize, maxTimeMS, comment);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> changeStream(FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<? extends Bson> pipeline, Decoder<TResult> decoder, ChangeStreamLevel changeStreamLevel, @Nullable Integer batchSize, Collation collation, BsonValue comment, long maxAwaitTimeMS, BsonDocument resumeToken, BsonTimestamp startAtOperationTime, BsonDocument startAfter, boolean showExpandedEvents) {
        return this.operations.changeStream(fullDocument, fullDocumentBeforeChange, pipeline, decoder, changeStreamLevel, batchSize, collation, comment, maxAwaitTimeMS, resumeToken, startAtOperationTime, startAfter, showExpandedEvents);
    }
}

