/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonBoolean;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonString;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoNamespace;
import io.github.apfelcreme.SupportTickets.lib.mongodb.WriteConcern;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.AsyncWriteBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.WriteBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.AsyncWriteOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.CommandOperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.OperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.WriteConcernHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.WriteOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;

public class RenameCollectionOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace originalNamespace;
    private final MongoNamespace newNamespace;
    private final WriteConcern writeConcern;
    private boolean dropTarget;

    public RenameCollectionOperation(MongoNamespace originalNamespace, MongoNamespace newNamespace) {
        this(originalNamespace, newNamespace, null);
    }

    public RenameCollectionOperation(MongoNamespace originalNamespace, MongoNamespace newNamespace, @Nullable WriteConcern writeConcern) {
        this.originalNamespace = Assertions.notNull("originalNamespace", originalNamespace);
        this.newNamespace = Assertions.notNull("newNamespace", newNamespace);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isDropTarget() {
        return this.dropTarget;
    }

    public RenameCollectionOperation dropTarget(boolean dropTarget) {
        this.dropTarget = dropTarget;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, connection -> CommandOperationHelper.executeCommand(binding, "admin", this.getCommand(), connection, CommandOperationHelper.writeConcernErrorTransformer()));
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        OperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                CommandOperationHelper.executeCommandAsync(binding, "admin", this.getCommand(), Assertions.assertNotNull(connection), CommandOperationHelper.writeConcernErrorWriteTransformer(), OperationHelper.releasingCallback(errHandlingCallback, connection));
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("renameCollection", new BsonString(this.originalNamespace.getFullName())).append("to", new BsonString(this.newNamespace.getFullName())).append("dropTarget", BsonBoolean.valueOf(this.dropTarget));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        return commandDocument;
    }
}

