/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonInt64;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Decoder;
import io.github.apfelcreme.SupportTickets.lib.bson.conversions.Bson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoClientException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoNamespace;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerAddress;
import io.github.apfelcreme.SupportTickets.lib.mongodb.WriteConcern;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.Collation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ConnectionDescription;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ServerDescription;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ServerType;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.AsyncBatchCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.function.AsyncCallbackBiFunction;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.function.AsyncCallbackFunction;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.function.AsyncCallbackSupplier;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.AsyncConnectionSource;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.AsyncReadBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.AsyncWriteBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.ConnectionSource;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.ReadBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.ReferenceCounted;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.WriteBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.bulk.DeleteRequest;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.bulk.UpdateRequest;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.bulk.WriteRequest;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.AsyncConnection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.Connection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.QueryResult;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.diagnostics.logging.Logger;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.diagnostics.logging.Loggers;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.AsyncQueryBatchCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.AsyncSingleBatchQueryCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.BatchCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.BsonDocumentWrapperHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.QueryBatchCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.ServerVersionHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.session.SessionContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.NonNull;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

final class OperationHelper {
    public static final Logger LOGGER = Loggers.getLogger("operation");

    static void validateCollationAndWriteConcern(@Nullable Collation collation, WriteConcern writeConcern) {
        if (collation != null && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying collation with an unacknowledged WriteConcern is not supported");
        }
    }

    private static void validateArrayFilters(WriteConcern writeConcern) {
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying array filters with an unacknowledged WriteConcern is not supported");
        }
    }

    private static void validateWriteRequestHint(ConnectionDescription connectionDescription, WriteConcern writeConcern, WriteRequest request) {
        if (!writeConcern.isAcknowledged()) {
            if (request instanceof UpdateRequest && ServerVersionHelper.serverIsLessThanVersionFourDotTwo(connectionDescription)) {
                throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
            }
            if (request instanceof DeleteRequest && ServerVersionHelper.serverIsLessThanVersionFourDotFour(connectionDescription)) {
                throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
            }
        }
    }

    static void validateHintForFindAndModify(ConnectionDescription connectionDescription, WriteConcern writeConcern) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotTwo(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
        if (!writeConcern.isAcknowledged() && ServerVersionHelper.serverIsLessThanVersionFourDotFour(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
    }

    static void validateWriteRequestCollations(List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        Collation collation = null;
        for (WriteRequest writeRequest : requests) {
            if (writeRequest instanceof UpdateRequest) {
                collation = ((UpdateRequest)writeRequest).getCollation();
            } else if (writeRequest instanceof DeleteRequest) {
                collation = ((DeleteRequest)writeRequest).getCollation();
            }
            if (collation == null) continue;
            break;
        }
        OperationHelper.validateCollationAndWriteConcern(collation, writeConcern);
    }

    static void validateUpdateRequestArrayFilters(List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        for (WriteRequest writeRequest : requests) {
            List<BsonDocument> arrayFilters = null;
            if (writeRequest instanceof UpdateRequest) {
                arrayFilters = ((UpdateRequest)writeRequest).getArrayFilters();
            }
            if (arrayFilters == null) continue;
            OperationHelper.validateArrayFilters(writeConcern);
            break;
        }
    }

    static void validateWriteRequestHints(ConnectionDescription connectionDescription, List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        for (WriteRequest writeRequest : requests) {
            Bson hint = null;
            String hintString = null;
            if (writeRequest instanceof UpdateRequest) {
                hint = ((UpdateRequest)writeRequest).getHint();
                hintString = ((UpdateRequest)writeRequest).getHintString();
            } else if (writeRequest instanceof DeleteRequest) {
                hint = ((DeleteRequest)writeRequest).getHint();
                hintString = ((DeleteRequest)writeRequest).getHintString();
            }
            if (hint == null && hintString == null) continue;
            OperationHelper.validateWriteRequestHint(connectionDescription, writeConcern, writeRequest);
            break;
        }
    }

    static void validateWriteRequests(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation, List<? extends WriteRequest> requests, WriteConcern writeConcern) {
        OperationHelper.checkBypassDocumentValidationIsSupported(bypassDocumentValidation, writeConcern);
        OperationHelper.validateWriteRequestCollations(requests, writeConcern);
        OperationHelper.validateUpdateRequestArrayFilters(requests, writeConcern);
        OperationHelper.validateWriteRequestHints(connectionDescription, requests, writeConcern);
    }

    static <R> boolean validateWriteRequestsAndCompleteIfInvalid(ConnectionDescription connectionDescription, Boolean bypassDocumentValidation, List<? extends WriteRequest> requests, WriteConcern writeConcern, SingleResultCallback<R> callback) {
        try {
            OperationHelper.validateWriteRequests(connectionDescription, bypassDocumentValidation, requests, writeConcern);
            return false;
        }
        catch (Throwable validationT) {
            callback.onResult(null, validationT);
            return true;
        }
    }

    static void checkBypassDocumentValidationIsSupported(@Nullable Boolean bypassDocumentValidation, WriteConcern writeConcern) {
        if (bypassDocumentValidation != null && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying bypassDocumentValidation with an unacknowledged WriteConcern is not supported");
        }
    }

    static boolean isRetryableWrite(boolean retryWrites, WriteConcern writeConcern, ServerDescription serverDescription, ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (!retryWrites) {
            return false;
        }
        if (!writeConcern.isAcknowledged()) {
            LOGGER.debug("retryWrites set to true but the writeConcern is unacknowledged.");
            return false;
        }
        if (sessionContext.hasActiveTransaction()) {
            LOGGER.debug("retryWrites set to true but in an active transaction.");
            return false;
        }
        return OperationHelper.canRetryWrite(serverDescription, connectionDescription, sessionContext);
    }

    static boolean canRetryWrite(ServerDescription serverDescription, ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (serverDescription.getLogicalSessionTimeoutMinutes() == null && serverDescription.getType() != ServerType.LOAD_BALANCER) {
            LOGGER.debug("retryWrites set to true but the server does not have 3.6 feature compatibility enabled.");
            return false;
        }
        if (connectionDescription.getServerType().equals((Object)ServerType.STANDALONE)) {
            LOGGER.debug("retryWrites set to true but the server is a standalone server.");
            return false;
        }
        if (!sessionContext.hasSession()) {
            LOGGER.debug("retryWrites set to true but there is no implicit session, likely because the MongoClient was created with multiple MongoCredential instances and sessions can only be used with a single MongoCredential");
            return false;
        }
        return true;
    }

    static boolean canRetryRead(ServerDescription serverDescription, SessionContext sessionContext) {
        if (sessionContext.hasActiveTransaction()) {
            LOGGER.debug("retryReads set to true but in an active transaction.");
            return false;
        }
        if (serverDescription.getLogicalSessionTimeoutMinutes() == null && serverDescription.getType() != ServerType.LOAD_BALANCER) {
            LOGGER.debug("retryReads set to true but the server does not have 3.6 feature compatibility enabled.");
            return false;
        }
        if (serverDescription.getType() != ServerType.STANDALONE && !sessionContext.hasSession()) {
            LOGGER.debug("retryReads set to true but there is no implicit session, likely because the MongoClient was created with multiple MongoCredential instances and sessions can only be used with a single MongoCredential");
            return false;
        }
        return true;
    }

    static <T> QueryBatchCursor<T> createEmptyBatchCursor(MongoNamespace namespace, Decoder<T> decoder, ServerAddress serverAddress, int batchSize) {
        return new QueryBatchCursor(new QueryResult(namespace, Collections.emptyList(), 0L, serverAddress), 0, batchSize, decoder);
    }

    static <T> AsyncBatchCursor<T> createEmptyAsyncBatchCursor(MongoNamespace namespace, ServerAddress serverAddress) {
        return new AsyncSingleBatchQueryCursor(new QueryResult(namespace, Collections.emptyList(), 0L, serverAddress));
    }

    static <T> BatchCursor<T> cursorDocumentToBatchCursor(BsonDocument cursorDocument, Decoder<T> decoder, BsonValue comment, ConnectionSource source, Connection connection, int batchSize) {
        return new QueryBatchCursor<T>(OperationHelper.cursorDocumentToQueryResult(cursorDocument, source.getServerDescription().getAddress()), 0, batchSize, 0L, decoder, comment, source, connection);
    }

    static <T> AsyncBatchCursor<T> cursorDocumentToAsyncBatchCursor(BsonDocument cursorDocument, Decoder<T> decoder, BsonValue comment, AsyncConnectionSource source, AsyncConnection connection, int batchSize) {
        return new AsyncQueryBatchCursor<T>(OperationHelper.cursorDocumentToQueryResult(cursorDocument, source.getServerDescription().getAddress()), 0, batchSize, 0L, decoder, comment, source, connection, cursorDocument);
    }

    static <T> QueryResult<T> cursorDocumentToQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress) {
        return OperationHelper.cursorDocumentToQueryResult(cursorDocument, serverAddress, "firstBatch");
    }

    static <T> QueryResult<T> getMoreCursorDocumentToQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress) {
        return OperationHelper.cursorDocumentToQueryResult(cursorDocument, serverAddress, "nextBatch");
    }

    private static <T> QueryResult<T> cursorDocumentToQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress, String fieldNameContainingBatch) {
        long cursorId = ((BsonInt64)cursorDocument.get("id")).getValue();
        MongoNamespace queryResultNamespace = new MongoNamespace(cursorDocument.getString("ns").getValue());
        return new QueryResult(queryResultNamespace, BsonDocumentWrapperHelper.toList(cursorDocument, fieldNameContainingBatch), cursorId, serverAddress);
    }

    static <T> SingleResultCallback<T> releasingCallback(SingleResultCallback<T> wrapped, AsyncConnection connection) {
        return new ReferenceCountedReleasingWrappedCallback<T>(wrapped, Collections.singletonList(connection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withReadConnectionSource(ReadBinding binding, CallableWithSource<T> callable) {
        ConnectionSource source = binding.getReadConnectionSource();
        try {
            T t = callable.call(source);
            return t;
        }
        finally {
            source.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnection(WriteBinding binding, CallableWithConnection<T> callable) {
        ConnectionSource source = binding.getWriteConnectionSource();
        try {
            T t = OperationHelper.withConnectionSource(source, callable);
            return t;
        }
        finally {
            source.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnectionSource(ConnectionSource source, CallableWithConnection<T> callable) {
        Connection connection = source.getConnection();
        try {
            T t = callable.call(connection);
            return t;
        }
        finally {
            connection.release();
        }
    }

    static <R> R withSourceAndConnection(Supplier<ConnectionSource> sourceSupplier, boolean wrapSourceConnectionException, BiFunction<ConnectionSource, Connection, R> function) throws ResourceSupplierInternalException {
        return (R)OperationHelper.withSuppliedResource(sourceSupplier, wrapSourceConnectionException, source -> OperationHelper.withSuppliedResource(source::getConnection, wrapSourceConnectionException, connection -> function.apply((ConnectionSource)source, (Connection)connection)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R, T extends ReferenceCounted> R withSuppliedResource(Supplier<T> resourceSupplier, boolean wrapSupplierException, Function<T, R> function) throws ResourceSupplierInternalException {
        ReferenceCounted resource = null;
        try {
            try {
                resource = (ReferenceCounted)resourceSupplier.get();
            }
            catch (Exception supplierException) {
                if (wrapSupplierException) {
                    throw new ResourceSupplierInternalException(supplierException);
                }
                throw supplierException;
            }
            R r = function.apply(resource);
            return r;
        }
        finally {
            if (resource != null) {
                resource.release();
            }
        }
    }

    static void withAsyncConnection(AsyncWriteBinding binding, AsyncCallableWithConnection callable) {
        binding.getWriteConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithConnectionCallback(callable), LOGGER));
    }

    static void withAsyncConnection(AsyncWriteBinding binding, AsyncCallableWithConnectionAndSource callable) {
        binding.getWriteConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithConnectionAndSourceCallback(callable), LOGGER));
    }

    static void withAsyncReadConnection(AsyncReadBinding binding, AsyncCallableWithSource callable) {
        binding.getReadConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithSourceCallback(callable), LOGGER));
    }

    static <R> void withAsyncSourceAndConnection(AsyncCallbackSupplier<AsyncConnectionSource> sourceAsyncSupplier, boolean wrapSourceConnectionException, SingleResultCallback<R> callback, AsyncCallbackBiFunction<AsyncConnectionSource, AsyncConnection, R> asyncFunction) throws ResourceSupplierInternalException {
        SingleResultCallback<R> errorHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        OperationHelper.withAsyncSuppliedResource(sourceAsyncSupplier, wrapSourceConnectionException, errorHandlingCallback, (source, sourceReleasingCallback) -> OperationHelper.withAsyncSuppliedResource(source::getConnection, wrapSourceConnectionException, sourceReleasingCallback, (connection, connectionAndSourceReleasingCallback) -> asyncFunction.apply((AsyncConnectionSource)source, (AsyncConnection)connection, connectionAndSourceReleasingCallback)));
    }

    static <R, T extends ReferenceCounted> void withAsyncSuppliedResource(AsyncCallbackSupplier<T> resourceSupplier, boolean wrapSourceConnectionException, SingleResultCallback<R> callback, AsyncCallbackFunction<T, R> function) throws ResourceSupplierInternalException {
        SingleResultCallback errorHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        resourceSupplier.get((resource, supplierException) -> {
            if (supplierException != null) {
                if (wrapSourceConnectionException) {
                    supplierException = new ResourceSupplierInternalException(supplierException);
                }
                errorHandlingCallback.onResult(null, supplierException);
            } else {
                Assertions.assertNotNull(resource);
                AsyncCallbackSupplier curriedFunction = clbk -> function.apply(resource, clbk);
                curriedFunction.whenComplete(resource::release).get(errorHandlingCallback);
            }
        });
    }

    private static void withAsyncConnectionSourceCallableConnection(AsyncConnectionSource source, AsyncCallableWithConnection callable) {
        source.getConnection((connection, t) -> {
            source.release();
            if (t != null) {
                callable.call(null, t);
            } else {
                callable.call((AsyncConnection)connection, null);
            }
        });
    }

    private static void withAsyncConnectionSource(AsyncConnectionSource source, AsyncCallableWithSource callable) {
        callable.call(source, null);
    }

    private static void withAsyncConnectionSource(AsyncConnectionSource source, AsyncCallableWithConnectionAndSource callable) {
        source.getConnection((result, t) -> callable.call(source, (AsyncConnection)result, t));
    }

    private OperationHelper() {
    }

    static interface AsyncCallableWithConnectionAndSource {
        public void call(@Nullable AsyncConnectionSource var1, @Nullable AsyncConnection var2, @Nullable Throwable var3);
    }

    static interface AsyncCallableWithSource {
        public void call(@Nullable AsyncConnectionSource var1, @Nullable Throwable var2);
    }

    static interface AsyncCallableWithConnection {
        public void call(@Nullable AsyncConnection var1, @Nullable Throwable var2);
    }

    private static class ReferenceCountedReleasingWrappedCallback<T>
    implements SingleResultCallback<T> {
        private final SingleResultCallback<T> wrapped;
        private final List<? extends ReferenceCounted> referenceCounted;

        ReferenceCountedReleasingWrappedCallback(SingleResultCallback<T> wrapped, List<? extends ReferenceCounted> referenceCounted) {
            this.wrapped = wrapped;
            this.referenceCounted = Assertions.notNull("referenceCounted", referenceCounted);
        }

        @Override
        public void onResult(@Nullable T result, @Nullable Throwable t) {
            for (ReferenceCounted referenceCounted : this.referenceCounted) {
                if (referenceCounted == null) continue;
                referenceCounted.release();
            }
            this.wrapped.onResult(result, t);
        }
    }

    static interface CallableWithSource<T> {
        public T call(ConnectionSource var1);
    }

    static interface CallableWithConnection<T> {
        public T call(Connection var1);
    }

    static final class ResourceSupplierInternalException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        private ResourceSupplierInternalException(Throwable cause) {
            super(Assertions.assertNotNull(cause));
        }

        @Override
        @NonNull
        public Throwable getCause() {
            return Assertions.assertNotNull(super.getCause());
        }
    }

    private static class AsyncCallableWithConnectionCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithConnection callable;

        AsyncCallableWithConnectionCallback(AsyncCallableWithConnection callable) {
            this.callable = callable;
        }

        @Override
        public void onResult(@Nullable AsyncConnectionSource source, @Nullable Throwable t) {
            if (t != null) {
                this.callable.call(null, t);
            } else {
                OperationHelper.withAsyncConnectionSourceCallableConnection(Assertions.assertNotNull(source), this.callable);
            }
        }
    }

    private static class AsyncCallableWithConnectionAndSourceCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithConnectionAndSource callable;

        AsyncCallableWithConnectionAndSourceCallback(AsyncCallableWithConnectionAndSource callable) {
            this.callable = callable;
        }

        @Override
        public void onResult(@Nullable AsyncConnectionSource source, @Nullable Throwable t) {
            if (t != null) {
                this.callable.call(null, null, t);
            } else {
                OperationHelper.withAsyncConnectionSource(Assertions.assertNotNull(source), this.callable);
            }
        }
    }

    private static class AsyncCallableWithSourceCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithSource callable;

        AsyncCallableWithSourceCallback(AsyncCallableWithSource callable) {
            this.callable = callable;
        }

        @Override
        public void onResult(@Nullable AsyncConnectionSource source, @Nullable Throwable t) {
            if (t != null) {
                this.callable.call(null, t);
            } else {
                OperationHelper.withAsyncConnectionSource(Assertions.assertNotNull(source), this.callable);
            }
        }
    }
}

