/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonInt64;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonString;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Decoder;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCommandException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoNamespace;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.AsyncBatchCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.function.AsyncCallbackSupplier;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.function.RetryState;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.AsyncConnectionSource;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.AsyncReadBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.ReadBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.AsyncReadOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.BatchCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.CommandOperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.CommandResultDocumentCodec;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.CursorHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.DocumentHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.OperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.ReadOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class ListIndexesOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private int batchSize;
    private long maxTimeMS;
    private BsonValue comment;

    public ListIndexesOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public ListIndexesOperation<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public ListIndexesOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public ListIndexesOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ListIndexesOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads);
        Supplier<BatchCursor> read = CommandOperationHelper.decorateReadWithRetries(retryState, () -> {
            CommandOperationHelper.logRetryExecute(retryState);
            return OperationHelper.withSourceAndConnection(binding::getReadConnectionSource, false, (source, connection) -> {
                retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), binding.getSessionContext()));
                try {
                    return CommandOperationHelper.createReadCommandAndExecute(retryState, binding, source, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), this.transformer(), connection);
                }
                catch (MongoCommandException e) {
                    return CommandOperationHelper.rethrowIfNotNamespaceError(e, OperationHelper.createEmptyBatchCursor(this.namespace, this.decoder, source.getServerDescription().getAddress(), this.batchSize));
                }
            });
        });
        return read.get();
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        RetryState retryState = CommandOperationHelper.initialRetryState(this.retryReads);
        binding.retain();
        AsyncCallbackSupplier<AsyncBatchCursor<T>> asyncRead = CommandOperationHelper.decorateReadWithRetries(retryState, funcCallback -> {
            CommandOperationHelper.logRetryExecute(retryState);
            OperationHelper.withAsyncSourceAndConnection(binding::getReadConnectionSource, false, funcCallback, (source, connection, releasingCallback) -> {
                if (retryState.breakAndCompleteIfRetryAnd(() -> !OperationHelper.canRetryRead(source.getServerDescription(), binding.getSessionContext()), releasingCallback)) {
                    return;
                }
                CommandOperationHelper.createReadCommandAndExecuteAsync(retryState, binding, source, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), this.asyncTransformer(), connection, (result, t) -> {
                    if (t != null && !CommandOperationHelper.isNamespaceError(t)) {
                        releasingCallback.onResult(null, t);
                    } else {
                        releasingCallback.onResult(result != null ? result : this.emptyAsyncCursor((AsyncConnectionSource)source), null);
                    }
                });
            });
        }).whenComplete(binding::release);
        asyncRead.get(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private AsyncBatchCursor<T> emptyAsyncCursor(AsyncConnectionSource source) {
        return OperationHelper.createEmptyAsyncBatchCursor(this.namespace, source.getServerDescription().getAddress());
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (serverDescription, connectionDescription) -> this.getCommand();
    }

    private BsonDocument getCommand() {
        BsonDocument command = new BsonDocument("listIndexes", new BsonString(this.namespace.getCollectionName())).append("cursor", CursorHelper.getCursorDocumentFromBatchSize(this.batchSize == 0 ? null : Integer.valueOf(this.batchSize)));
        if (this.maxTimeMS > 0L) {
            command.put("maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        DocumentHelper.putIfNotNull(command, "comment", this.comment);
        return command;
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, BatchCursor<T>> transformer() {
        return (result, source, connection) -> OperationHelper.cursorDocumentToBatchCursor(result.getDocument("cursor"), this.decoder, this.comment, source, connection, this.batchSize);
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection) -> OperationHelper.cursorDocumentToAsyncBatchCursor(result.getDocument("cursor"), this.decoder, this.comment, source, connection, this.batchSize);
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, "firstBatch");
    }
}

