/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonArray;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonBoolean;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonInt32;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoWriteConcernException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerAddress;
import io.github.apfelcreme.SupportTickets.lib.mongodb.WriteConcernResult;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.BsonDocumentWrapperHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.CommandOperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.WriteConcernHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;

final class FindAndModifyHelper {
    static <T> CommandOperationHelper.CommandWriteTransformer<BsonDocument, T> transformer() {
        return (result, connection) -> FindAndModifyHelper.transformDocument(result, connection.getDescription().getServerAddress());
    }

    static <T> CommandOperationHelper.CommandWriteTransformerAsync<BsonDocument, T> asyncTransformer() {
        return (result, connection) -> FindAndModifyHelper.transformDocument(result, connection.getDescription().getServerAddress());
    }

    @Nullable
    private static <T> T transformDocument(BsonDocument result, ServerAddress serverAddress) {
        if (WriteConcernHelper.hasWriteConcernError(result)) {
            MongoWriteConcernException writeConcernException = new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(result.getDocument("writeConcernError")), FindAndModifyHelper.createWriteConcernResult(result.getDocument("lastErrorObject", new BsonDocument())), serverAddress);
            result.getArray("errorLabels", new BsonArray()).stream().map(i -> i.asString().getValue()).forEach(writeConcernException::addLabel);
            throw writeConcernException;
        }
        if (!result.isDocument("value")) {
            return null;
        }
        return BsonDocumentWrapperHelper.toDocument(result.getDocument("value", null));
    }

    private static WriteConcernResult createWriteConcernResult(BsonDocument result) {
        BsonBoolean updatedExisting = result.getBoolean("updatedExisting", BsonBoolean.FALSE);
        return WriteConcernResult.acknowledged(result.getNumber("n", new BsonInt32(0)).intValue(), updatedExisting.getValue(), result.get("upserted"));
    }

    private FindAndModifyHelper() {
    }
}

