/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonString;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonDocumentCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Decoder;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCommandException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoNamespace;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ConnectionDescription;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.AsyncReadBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.ReadBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.AsyncReadOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.CommandOperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.CommandResultDocumentCodec;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.DocumentHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.OperationReadConcernHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.ReadOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.session.SessionContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;

public class EstimatedDocumentCountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private static final Decoder<BsonDocument> DECODER = new BsonDocumentCodec();
    private final MongoNamespace namespace;
    private boolean retryReads;
    private long maxTimeMS;
    private BsonValue comment;

    public EstimatedDocumentCountOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public EstimatedDocumentCountOperation retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public EstimatedDocumentCountOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public EstimatedDocumentCountOperation comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public Long execute(ReadBinding binding) {
        try {
            return CommandOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.transformer(), this.retryReads);
        }
        catch (MongoCommandException e) {
            return Assertions.assertNotNull(CommandOperationHelper.rethrowIfNotNamespaceError(e, 0L));
        }
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<Long> callback) {
        CommandOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(DECODER, Collections.singletonList("firstBatch")), this.asyncTransformer(), this.retryReads, (result, t) -> {
            if (CommandOperationHelper.isNamespaceError(t)) {
                callback.onResult(0L, null);
            } else {
                callback.onResult((Long)result, t);
            }
        });
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, Long> transformer() {
        return (result, source, connection) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, Long> asyncTransformer() {
        return (result, source, connection) -> this.transformResult((BsonDocument)result, connection.getDescription());
    }

    private long transformResult(BsonDocument result, ConnectionDescription connectionDescription) {
        return result.getNumber("n").longValue();
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(SessionContext sessionContext) {
        return (serverDescription, connectionDescription) -> {
            BsonDocument document = new BsonDocument("count", new BsonString(this.namespace.getCollectionName()));
            OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, connectionDescription.getMaxWireVersion(), document);
            DocumentHelper.putIfNotZero(document, "maxTimeMS", this.maxTimeMS);
            if (this.comment != null) {
                document.put("comment", this.comment);
            }
            return document;
        };
    }
}

