/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonInt32;
import io.github.apfelcreme.SupportTickets.lib.mongodb.WriteConcern;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.AsyncWriteBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.WriteBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.AsyncWriteOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.CommandOperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.OperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.WriteConcernHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.WriteOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;

public class DropDatabaseOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final String databaseName;
    private final WriteConcern writeConcern;

    public DropDatabaseOperation(String databaseName) {
        this(databaseName, null);
    }

    public DropDatabaseOperation(String databaseName, @Nullable WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, connection -> {
            CommandOperationHelper.executeCommand(binding, this.databaseName, this.getCommand(), connection, CommandOperationHelper.writeConcernErrorTransformer());
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        OperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                CommandOperationHelper.executeCommandAsync(binding, this.databaseName, this.getCommand(), connection, CommandOperationHelper.writeConcernErrorWriteTransformer(), OperationHelper.releasingCallback(errHandlingCallback, connection));
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("dropDatabase", new BsonInt32(1));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, commandDocument);
        return commandDocument;
    }
}

