/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonArray;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonBoolean;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonString;
import io.github.apfelcreme.SupportTickets.lib.mongodb.WriteConcern;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.ChangeStreamPreAndPostImagesOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.Collation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.TimeSeriesGranularity;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.TimeSeriesOptions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.ValidationAction;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.ValidationLevel;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.AsyncWriteBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.WriteBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.AsyncConnection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.AsyncWriteOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.CommandOperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.DocumentHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.OperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.WriteConcernHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.WriteOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;

public class CreateCollectionOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private static final String ENCRYPT_PREFIX = "enxcol_.";
    private static final BsonDocument ENCRYPT_CLUSTERED_INDEX = BsonDocument.parse("{key: {_id: 1}, unique: true}");
    private static final BsonArray SAFE_CONTENT_ARRAY = new BsonArray(Collections.singletonList(BsonDocument.parse("{key: {__safeContent__: 1}, name: '__safeContent___1'}")));
    private final String databaseName;
    private final String collectionName;
    private final WriteConcern writeConcern;
    private boolean capped = false;
    private long sizeInBytes = 0L;
    private boolean autoIndex = true;
    private long maxDocuments = 0L;
    private BsonDocument storageEngineOptions;
    private BsonDocument indexOptionDefaults;
    private BsonDocument validator;
    private ValidationLevel validationLevel = null;
    private ValidationAction validationAction = null;
    private Collation collation = null;
    private long expireAfterSeconds;
    private TimeSeriesOptions timeSeriesOptions;
    private ChangeStreamPreAndPostImagesOptions changeStreamPreAndPostImagesOptions;
    private BsonDocument clusteredIndexKey;
    private boolean clusteredIndexUnique;
    private String clusteredIndexName;
    private BsonDocument encryptedFields;

    public CreateCollectionOperation(String databaseName, String collectionName) {
        this(databaseName, collectionName, null);
    }

    public CreateCollectionOperation(String databaseName, String collectionName, @Nullable WriteConcern writeConcern) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.collectionName = Assertions.notNull("collectionName", collectionName);
        this.writeConcern = writeConcern;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    public CreateCollectionOperation autoIndex(boolean autoIndex) {
        this.autoIndex = autoIndex;
        return this;
    }

    public long getMaxDocuments() {
        return this.maxDocuments;
    }

    public CreateCollectionOperation maxDocuments(long maxDocuments) {
        this.maxDocuments = maxDocuments;
        return this;
    }

    public boolean isCapped() {
        return this.capped;
    }

    public CreateCollectionOperation capped(boolean capped) {
        this.capped = capped;
        return this;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public CreateCollectionOperation sizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    public BsonDocument getStorageEngineOptions() {
        return this.storageEngineOptions;
    }

    public CreateCollectionOperation storageEngineOptions(@Nullable BsonDocument storageEngineOptions) {
        this.storageEngineOptions = storageEngineOptions;
        return this;
    }

    public BsonDocument getIndexOptionDefaults() {
        return this.indexOptionDefaults;
    }

    public CreateCollectionOperation indexOptionDefaults(@Nullable BsonDocument indexOptionDefaults) {
        this.indexOptionDefaults = indexOptionDefaults;
        return this;
    }

    public BsonDocument getValidator() {
        return this.validator;
    }

    public CreateCollectionOperation validator(@Nullable BsonDocument validator) {
        this.validator = validator;
        return this;
    }

    public ValidationLevel getValidationLevel() {
        return this.validationLevel;
    }

    public CreateCollectionOperation validationLevel(@Nullable ValidationLevel validationLevel) {
        this.validationLevel = validationLevel;
        return this;
    }

    public ValidationAction getValidationAction() {
        return this.validationAction;
    }

    public CreateCollectionOperation validationAction(@Nullable ValidationAction validationAction) {
        this.validationAction = validationAction;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CreateCollectionOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public CreateCollectionOperation expireAfter(long expireAfterSeconds) {
        this.expireAfterSeconds = expireAfterSeconds;
        return this;
    }

    public CreateCollectionOperation timeSeriesOptions(@Nullable TimeSeriesOptions timeSeriesOptions) {
        this.timeSeriesOptions = timeSeriesOptions;
        return this;
    }

    public CreateCollectionOperation changeStreamPreAndPostImagesOptions(@Nullable ChangeStreamPreAndPostImagesOptions changeStreamPreAndPostImagesOptions) {
        this.changeStreamPreAndPostImagesOptions = changeStreamPreAndPostImagesOptions;
        return this;
    }

    public CreateCollectionOperation clusteredIndexKey(@Nullable BsonDocument clusteredIndexKey) {
        this.clusteredIndexKey = clusteredIndexKey;
        return this;
    }

    public CreateCollectionOperation clusteredIndexUnique(boolean clusteredIndexUnique) {
        this.clusteredIndexUnique = clusteredIndexUnique;
        return this;
    }

    public CreateCollectionOperation clusteredIndexName(@Nullable String clusteredIndexName) {
        this.clusteredIndexName = clusteredIndexName;
        return this;
    }

    public CreateCollectionOperation encryptedFields(@Nullable BsonDocument encryptedFields) {
        this.encryptedFields = encryptedFields;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, connection -> {
            this.getCommandFunctions().forEach(commandCreator -> CommandOperationHelper.executeCommand(binding, this.databaseName, (BsonDocument)commandCreator.get(), connection, CommandOperationHelper.writeConcernErrorTransformer()));
            return null;
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        OperationHelper.withAsyncConnection(binding, (connection, t) -> {
            SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
            if (t != null) {
                errHandlingCallback.onResult(null, t);
            } else {
                new ProcessCommandsCallback(binding, connection, OperationHelper.releasingCallback(errHandlingCallback, connection)).onResult(null, null);
            }
        });
    }

    private String getGranularityAsString(TimeSeriesGranularity granularity) {
        switch (granularity) {
            case SECONDS: {
                return "seconds";
            }
            case MINUTES: {
                return "minutes";
            }
            case HOURS: {
                return "hours";
            }
        }
        throw new AssertionError((Object)("Unexpected granularity " + (Object)((Object)granularity)));
    }

    private List<Supplier<BsonDocument>> getCommandFunctions() {
        if (this.encryptedFields == null) {
            return Collections.singletonList(this::getCreateCollectionCommand);
        }
        return Arrays.asList(() -> this.getCreateEncryptedFieldsCollectionCommand("esc"), () -> this.getCreateEncryptedFieldsCollectionCommand("ecc"), () -> this.getCreateEncryptedFieldsCollectionCommand("ecoc"), this::getCreateCollectionCommand, () -> new BsonDocument("createIndexes", new BsonString(this.collectionName)).append("indexes", SAFE_CONTENT_ARRAY));
    }

    private BsonDocument getCreateEncryptedFieldsCollectionCommand(String collectionSuffix) {
        return new BsonDocument().append("create", this.encryptedFields.getOrDefault(collectionSuffix + "Collection", new BsonString(ENCRYPT_PREFIX + this.collectionName + "." + collectionSuffix))).append("clusteredIndex", ENCRYPT_CLUSTERED_INDEX);
    }

    private BsonDocument getCreateCollectionCommand() {
        BsonDocument document = new BsonDocument("create", new BsonString(this.collectionName));
        DocumentHelper.putIfFalse(document, "autoIndexId", this.autoIndex);
        document.put("capped", BsonBoolean.valueOf(this.capped));
        if (this.capped) {
            DocumentHelper.putIfNotZero(document, "size", this.sizeInBytes);
            DocumentHelper.putIfNotZero(document, "max", this.maxDocuments);
        }
        DocumentHelper.putIfNotNull(document, "storageEngine", this.storageEngineOptions);
        DocumentHelper.putIfNotNull(document, "indexOptionDefaults", this.indexOptionDefaults);
        DocumentHelper.putIfNotNull(document, "validator", this.validator);
        if (this.validationLevel != null) {
            document.put("validationLevel", new BsonString(this.validationLevel.getValue()));
        }
        if (this.validationAction != null) {
            document.put("validationAction", new BsonString(this.validationAction.getValue()));
        }
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, document);
        if (this.collation != null) {
            document.put("collation", this.collation.asDocument());
        }
        DocumentHelper.putIfNotZero(document, "expireAfterSeconds", this.expireAfterSeconds);
        if (this.timeSeriesOptions != null) {
            TimeSeriesGranularity granularity;
            BsonDocument timeSeriesDocument = new BsonDocument("timeField", new BsonString(this.timeSeriesOptions.getTimeField()));
            String metaField = this.timeSeriesOptions.getMetaField();
            if (metaField != null) {
                timeSeriesDocument.put("metaField", new BsonString(metaField));
            }
            if ((granularity = this.timeSeriesOptions.getGranularity()) != null) {
                timeSeriesDocument.put("granularity", new BsonString(this.getGranularityAsString(granularity)));
            }
            document.put("timeseries", timeSeriesDocument);
        }
        if (this.changeStreamPreAndPostImagesOptions != null) {
            document.put("changeStreamPreAndPostImages", new BsonDocument("enabled", BsonBoolean.valueOf(this.changeStreamPreAndPostImagesOptions.isEnabled())));
        }
        if (this.clusteredIndexKey != null) {
            BsonDocument clusteredIndexDocument = new BsonDocument().append("key", this.clusteredIndexKey).append("unique", BsonBoolean.valueOf(this.clusteredIndexUnique));
            if (this.clusteredIndexName != null) {
                clusteredIndexDocument.put("name", new BsonString(this.clusteredIndexName));
            }
            document.put("clusteredIndex", clusteredIndexDocument);
        }
        DocumentHelper.putIfNotNull(document, "encryptedFields", this.encryptedFields);
        return document;
    }

    class ProcessCommandsCallback
    implements SingleResultCallback<Void> {
        private final AsyncWriteBinding binding;
        private final AsyncConnection connection;
        private final SingleResultCallback<Void> finalCallback;
        private final Deque<Supplier<BsonDocument>> commands;

        ProcessCommandsCallback(AsyncWriteBinding binding, AsyncConnection connection, SingleResultCallback<Void> finalCallback) {
            this.binding = binding;
            this.connection = connection;
            this.finalCallback = finalCallback;
            this.commands = new ArrayDeque<Supplier<BsonDocument>>(CreateCollectionOperation.this.getCommandFunctions());
        }

        @Override
        public void onResult(@Nullable Void result, @Nullable Throwable t) {
            if (t != null) {
                this.finalCallback.onResult(null, t);
                return;
            }
            Supplier<BsonDocument> nextCommandFunction = this.commands.poll();
            if (nextCommandFunction == null) {
                this.finalCallback.onResult(null, null);
            } else {
                CommandOperationHelper.executeCommandAsync(this.binding, CreateCollectionOperation.this.databaseName, nextCommandFunction.get(), this.connection, CommandOperationHelper.writeConcernErrorWriteTransformer(), this);
            }
        }
    }
}

