/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonArray;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonArrayCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonBinaryCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonBooleanCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonDBPointerCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonDateTimeCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonDecimal128Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonDocumentCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonDoubleCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonInt32Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonInt64Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonJavaScriptCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonJavaScriptWithScopeCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonMaxKeyCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonMinKeyCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonNullCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonObjectIdCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonRegularExpressionCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonStringCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonSymbolCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonTimestampCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonUndefinedCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Codec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Decoder;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecProvider;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistry;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.CommandResultDocumentCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CommandResultCodecProvider<P>
implements CodecProvider {
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();
    private final Decoder<P> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultCodecProvider(Decoder<P> payloadDecoder, List<String> fieldContainingPayload) {
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldContainingPayload;
        this.addCodecs();
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonArray.class) {
            return new BsonArrayCodec(registry);
        }
        if (clazz == BsonDocument.class) {
            return new CommandResultDocumentCodec<P>(registry, this.payloadDecoder, this.fieldsContainingPayload);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
        this.addCodec(new BsonJavaScriptWithScopeCodec(new BsonDocumentCodec()));
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandResultCodecProvider that = (CommandResultCodecProvider)o;
        if (!this.fieldsContainingPayload.equals(that.fieldsContainingPayload)) {
            return false;
        }
        return this.payloadDecoder.getClass().equals(that.payloadDecoder.getClass());
    }

    public int hashCode() {
        int result = this.payloadDecoder.getClass().hashCode();
        result = 31 * result + this.fieldsContainingPayload.hashCode();
        return result;
    }
}

