/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonArray;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocumentWrapper;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonReader;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonType;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonArrayCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Decoder;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.DecoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistry;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.BsonArrayWrapper;
import java.util.ArrayList;

class CommandResultArrayCodec<T>
extends BsonArrayCodec {
    private final Decoder<T> decoder;

    CommandResultArrayCodec(CodecRegistry registry, Decoder<T> decoder) {
        super(registry);
        this.decoder = decoder;
    }

    @Override
    public BsonArray decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<T> list = new ArrayList<T>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                list.add(null);
                continue;
            }
            list.add(this.decoder.decode(reader, decoderContext));
        }
        reader.readEndArray();
        return new BsonArrayWrapper(list);
    }

    @Override
    protected BsonValue readValue(BsonReader reader, DecoderContext decoderContext) {
        if (reader.getCurrentBsonType() == BsonType.DOCUMENT) {
            return new BsonDocumentWrapper<T>(this.decoder.decode(reader, decoderContext), null);
        }
        return super.readValue(reader, decoderContext);
    }
}

