/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonTimestamp;
import io.github.apfelcreme.SupportTickets.lib.bson.RawBsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Decoder;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoChangeStreamException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerAddress;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.binding.ReadBinding;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.AggregateResponseBatchCursor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.ChangeStreamBatchCursorHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.ChangeStreamOperation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.operation.OperationHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

final class ChangeStreamBatchCursor<T>
implements AggregateResponseBatchCursor<T> {
    private final ReadBinding binding;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private final int maxWireVersion;
    private AggregateResponseBatchCursor<RawBsonDocument> wrapped;
    private BsonDocument resumeToken;
    private final AtomicBoolean closed;

    ChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, AggregateResponseBatchCursor<RawBsonDocument> wrapped, ReadBinding binding, @Nullable BsonDocument resumeToken, int maxWireVersion) {
        this.changeStreamOperation = changeStreamOperation;
        this.binding = binding.retain();
        this.wrapped = wrapped;
        this.resumeToken = resumeToken;
        this.maxWireVersion = maxWireVersion;
        this.closed = new AtomicBoolean();
    }

    AggregateResponseBatchCursor<RawBsonDocument> getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean hasNext() {
        return this.resumeableOperation(queryBatchCursor -> {
            try {
                Boolean bl = queryBatchCursor.hasNext();
                return bl;
            }
            finally {
                this.cachePostBatchResumeToken((AggregateResponseBatchCursor<RawBsonDocument>)queryBatchCursor);
            }
        });
    }

    @Override
    public List<T> next() {
        return this.resumeableOperation(queryBatchCursor -> {
            try {
                List<T> list = ChangeStreamBatchCursor.convertAndProduceLastId((List<RawBsonDocument>)queryBatchCursor.next(), this.changeStreamOperation.getDecoder(), lastId -> {
                    this.resumeToken = lastId;
                });
                return list;
            }
            finally {
                this.cachePostBatchResumeToken((AggregateResponseBatchCursor<RawBsonDocument>)queryBatchCursor);
            }
        });
    }

    @Override
    public int available() {
        return this.wrapped.available();
    }

    @Override
    public List<T> tryNext() {
        return this.resumeableOperation(queryBatchCursor -> {
            try {
                List<T> list = ChangeStreamBatchCursor.convertAndProduceLastId(queryBatchCursor.tryNext(), this.changeStreamOperation.getDecoder(), lastId -> {
                    this.resumeToken = lastId;
                });
                return list;
            }
            finally {
                this.cachePostBatchResumeToken((AggregateResponseBatchCursor<RawBsonDocument>)queryBatchCursor);
            }
        });
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.wrapped.close();
            this.binding.release();
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.wrapped.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    @Override
    public ServerCursor getServerCursor() {
        return this.wrapped.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.wrapped.getServerAddress();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.wrapped.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.changeStreamOperation.getStartAtOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.wrapped.isFirstBatchEmpty();
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void cachePostBatchResumeToken(AggregateResponseBatchCursor<RawBsonDocument> queryBatchCursor) {
        if (queryBatchCursor.getPostBatchResumeToken() != null) {
            this.resumeToken = queryBatchCursor.getPostBatchResumeToken();
        }
    }

    @Nullable
    static <T> List<T> convertAndProduceLastId(@Nullable List<RawBsonDocument> rawDocuments, Decoder<T> decoder, Consumer<BsonDocument> lastIdConsumer) {
        ArrayList<T> results = null;
        if (rawDocuments != null) {
            results = new ArrayList<T>();
            for (RawBsonDocument rawDocument : rawDocuments) {
                if (!rawDocument.containsKey("_id")) {
                    throw new MongoChangeStreamException("Cannot provide resume functionality when the resume token is missing.");
                }
                results.add(rawDocument.decode(decoder));
            }
            lastIdConsumer.accept(rawDocuments.get(rawDocuments.size() - 1).getDocument("_id"));
        }
        return results;
    }

    <R> R resumeableOperation(Function<AggregateResponseBatchCursor<RawBsonDocument>, R> function) {
        while (true) {
            try {
                return function.apply(this.wrapped);
            }
            catch (Throwable t) {
                if (!ChangeStreamBatchCursorHelper.isResumableError(t, this.maxWireVersion)) {
                    throw MongoException.fromThrowableNonNull(t);
                }
                this.wrapped.close();
                OperationHelper.withReadConnectionSource(this.binding, source -> {
                    this.changeStreamOperation.setChangeStreamOptionsForResume(this.resumeToken, source.getServerDescription().getMaxWireVersion());
                    return null;
                });
                this.wrapped = ((ChangeStreamBatchCursor)this.changeStreamOperation.execute(this.binding)).getWrapped();
                this.binding.release();
                continue;
            }
            break;
        }
    }
}

