/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.event;

import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.ClusterClosedEvent;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.ClusterDescriptionChangedEvent;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.ClusterListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.ClusterOpeningEvent;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.diagnostics.logging.Logger;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.diagnostics.logging.Loggers;
import java.util.ArrayList;
import java.util.List;

final class ClusterListenerMulticaster
implements ClusterListener {
    private static final Logger LOGGER = Loggers.getLogger("cluster.event");
    private final List<ClusterListener> clusterListeners;

    ClusterListenerMulticaster(List<ClusterListener> clusterListeners) {
        Assertions.isTrue("All ClusterListener instances are non-null", !clusterListeners.contains(null));
        this.clusterListeners = new ArrayList<ClusterListener>(clusterListeners);
    }

    @Override
    public void clusterOpening(ClusterOpeningEvent event) {
        for (ClusterListener cur : this.clusterListeners) {
            try {
                cur.clusterOpening(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising cluster opening event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void clusterClosed(ClusterClosedEvent event) {
        for (ClusterListener cur : this.clusterListeners) {
            try {
                cur.clusterClosed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising cluster closed event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void clusterDescriptionChanged(ClusterDescriptionChangedEvent event) {
        for (ClusterListener cur : this.clusterListeners) {
            try {
                cur.clusterDescriptionChanged(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising cluster description changed event to listener %s", cur), e);
            }
        }
    }
}

