/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection;

import io.github.apfelcreme.SupportTickets.lib.bson.io.OutputBuffer;
import io.github.apfelcreme.SupportTickets.lib.mongodb.RequestContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.CommandListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.InternalConnection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ProtocolHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.RequestMessage;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ResponseBuffers;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;

class SendMessageCallback<T>
implements SingleResultCallback<Void> {
    private final OutputBuffer buffer;
    private final InternalConnection connection;
    private final SingleResultCallback<ResponseBuffers> receiveMessageCallback;
    private final int requestId;
    private final RequestMessage message;
    private final CommandListener commandListener;
    private final long startTimeNanos;
    private final RequestContext requestContext;
    private final SingleResultCallback<T> callback;
    private final String commandName;

    SendMessageCallback(InternalConnection connection, OutputBuffer buffer, RequestMessage message, String commandName, long startTimeNanos, CommandListener commandListener, RequestContext requestContext, SingleResultCallback<T> callback, SingleResultCallback<ResponseBuffers> receiveMessageCallback) {
        this.buffer = buffer;
        this.connection = connection;
        this.message = message;
        this.commandName = commandName;
        this.commandListener = commandListener;
        this.startTimeNanos = startTimeNanos;
        this.requestContext = Assertions.notNull("requestContext", requestContext);
        this.callback = callback;
        this.receiveMessageCallback = receiveMessageCallback;
        this.requestId = message.getId();
    }

    @Override
    public void onResult(@Nullable Void result, @Nullable Throwable t) {
        this.buffer.close();
        if (t != null) {
            if (this.commandListener != null) {
                ProtocolHelper.sendCommandFailedEvent(this.message, this.commandName, this.connection.getDescription(), System.nanoTime() - this.startTimeNanos, t, this.commandListener, this.requestContext);
            }
            this.callback.onResult(null, t);
        } else {
            this.connection.receiveMessageAsync(this.requestId, this.receiveMessageCallback);
        }
    }
}

