/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonBinaryReader;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonInt32;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonReader;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonString;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonTimestamp;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonType;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonValueCodecProvider;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.DecoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistries;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.configuration.CodecRegistry;
import io.github.apfelcreme.SupportTickets.lib.bson.io.ByteBufferBsonInput;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ErrorCategory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCommandException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoExecutionTimeoutException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoNodeIsRecoveringException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoNotPrimaryException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoQueryException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.RequestContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerAddress;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ConnectionDescription;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.CommandFailedEvent;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.CommandListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.CommandStartedEvent;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.CommandSucceededEvent;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.IgnorableRequestContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.MessageSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.RequestMessage;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ResponseBuffers;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.diagnostics.logging.Logger;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.diagnostics.logging.Loggers;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ProtocolHelper {
    private static final Logger PROTOCOL_EVENT_LOGGER = Loggers.getLogger("protocol.event");
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final int NO_ERROR_CODE = -1;
    private static final List<Integer> NOT_PRIMARY_CODES = Arrays.asList(10107, 13435, 10058);
    private static final List<String> NOT_PRIMARY_MESSAGES = Collections.singletonList("not master");
    private static final List<Integer> RECOVERING_CODES = Arrays.asList(11600, 11602, 13436, 189, 91);
    private static final List<String> RECOVERING_MESSAGES = Arrays.asList("not master or secondary", "node is recovering");

    static boolean isCommandOk(BsonDocument response) {
        BsonValue okValue = response.get("ok");
        return ProtocolHelper.isCommandOk(okValue);
    }

    static boolean isCommandOk(BsonReader bsonReader) {
        return ProtocolHelper.isCommandOk(ProtocolHelper.getField(bsonReader, "ok"));
    }

    static boolean isCommandOk(ResponseBuffers responseBuffers) {
        try {
            boolean bl = ProtocolHelper.isCommandOk(ProtocolHelper.createBsonReader(responseBuffers));
            return bl;
        }
        finally {
            responseBuffers.reset();
        }
    }

    @Nullable
    static MongoException createSpecialWriteConcernException(ResponseBuffers responseBuffers, ServerAddress serverAddress) {
        BsonValue writeConcernError = ProtocolHelper.getField(ProtocolHelper.createBsonReader(responseBuffers), "writeConcernError");
        if (writeConcernError == null) {
            return null;
        }
        return ProtocolHelper.createSpecialException(writeConcernError.asDocument(), serverAddress, "errmsg");
    }

    @Nullable
    static BsonTimestamp getOperationTime(ResponseBuffers responseBuffers) {
        return ProtocolHelper.getFieldValueAsTimestamp(responseBuffers, "operationTime");
    }

    @Nullable
    static BsonDocument getClusterTime(ResponseBuffers responseBuffers) {
        return ProtocolHelper.getFieldValueAsDocument(responseBuffers, "$clusterTime");
    }

    @Nullable
    static BsonTimestamp getSnapshotTimestamp(ResponseBuffers responseBuffers) {
        BsonValue atClusterTimeValue = ProtocolHelper.getNestedFieldValue(responseBuffers, "cursor", "atClusterTime");
        if (atClusterTimeValue == null) {
            atClusterTimeValue = ProtocolHelper.getFieldValue(responseBuffers, "atClusterTime");
        }
        if (atClusterTimeValue != null && atClusterTimeValue.isTimestamp()) {
            return atClusterTimeValue.asTimestamp();
        }
        return null;
    }

    @Nullable
    static BsonDocument getRecoveryToken(ResponseBuffers responseBuffers) {
        return ProtocolHelper.getFieldValueAsDocument(responseBuffers, "recoveryToken");
    }

    @Nullable
    private static BsonTimestamp getFieldValueAsTimestamp(ResponseBuffers responseBuffers, String fieldName) {
        BsonValue value = ProtocolHelper.getFieldValue(responseBuffers, fieldName);
        if (value == null) {
            return null;
        }
        return value.asTimestamp();
    }

    @Nullable
    private static BsonDocument getFieldValueAsDocument(ResponseBuffers responseBuffers, String fieldName) {
        BsonValue value = ProtocolHelper.getFieldValue(responseBuffers, fieldName);
        if (value == null) {
            return null;
        }
        return value.asDocument();
    }

    @Nullable
    private static BsonValue getFieldValue(ResponseBuffers responseBuffers, String fieldName) {
        try {
            BsonValue bsonValue = ProtocolHelper.getField(ProtocolHelper.createBsonReader(responseBuffers), fieldName);
            return bsonValue;
        }
        finally {
            responseBuffers.reset();
        }
    }

    private static BsonBinaryReader createBsonReader(ResponseBuffers responseBuffers) {
        return new BsonBinaryReader(new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer()));
    }

    @Nullable
    private static BsonValue getField(BsonReader bsonReader, String fieldName) {
        bsonReader.readStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (bsonReader.readName().equals(fieldName)) {
                return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType(bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
            }
            bsonReader.skipValue();
        }
        bsonReader.readEndDocument();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static BsonValue getNestedFieldValue(ResponseBuffers responseBuffers, String topLevelFieldName, String nestedFieldName) {
        try {
            BsonBinaryReader bsonReader = ProtocolHelper.createBsonReader(responseBuffers);
            bsonReader.readStartDocument();
            while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (bsonReader.readName().equals(topLevelFieldName)) {
                    BsonValue bsonValue = ProtocolHelper.getField(bsonReader, nestedFieldName);
                    return bsonValue;
                }
                bsonReader.skipValue();
            }
            bsonReader.readEndDocument();
            BsonValue bsonValue = null;
            return bsonValue;
        }
        finally {
            responseBuffers.reset();
        }
    }

    private static boolean isCommandOk(@Nullable BsonValue okValue) {
        if (okValue == null) {
            return false;
        }
        if (okValue.isBoolean()) {
            return okValue.asBoolean().getValue();
        }
        if (okValue.isNumber()) {
            return okValue.asNumber().intValue() == 1;
        }
        return false;
    }

    static MongoException getCommandFailureException(BsonDocument response, ServerAddress serverAddress) {
        MongoException specialException = ProtocolHelper.createSpecialException(response, serverAddress, "errmsg");
        if (specialException != null) {
            return specialException;
        }
        return new MongoCommandException(response, serverAddress);
    }

    static int getErrorCode(BsonDocument response) {
        return response.getNumber("code", new BsonInt32(-1)).intValue();
    }

    static String getErrorMessage(BsonDocument response, String errorMessageFieldName) {
        return response.getString(errorMessageFieldName, new BsonString("")).getValue();
    }

    static MongoException getQueryFailureException(BsonDocument errorDocument, ServerAddress serverAddress) {
        MongoException specialException = ProtocolHelper.createSpecialException(errorDocument, serverAddress, "$err");
        if (specialException != null) {
            return specialException;
        }
        return new MongoQueryException(errorDocument, serverAddress);
    }

    static MessageSettings getMessageSettings(ConnectionDescription connectionDescription) {
        return MessageSettings.builder().maxDocumentSize(connectionDescription.getMaxDocumentSize()).maxMessageSize(connectionDescription.getMaxMessageSize()).maxBatchCount(connectionDescription.getMaxBatchCount()).maxWireVersion(connectionDescription.getMaxWireVersion()).serverType(connectionDescription.getServerType()).build();
    }

    @Nullable
    public static MongoException createSpecialException(@Nullable BsonDocument response, ServerAddress serverAddress, String errorMessageFieldName) {
        if (response == null) {
            return null;
        }
        int errorCode = ProtocolHelper.getErrorCode(response);
        String errorMessage = ProtocolHelper.getErrorMessage(response, errorMessageFieldName);
        if (ErrorCategory.fromErrorCode(errorCode) == ErrorCategory.EXECUTION_TIMEOUT) {
            return new MongoExecutionTimeoutException(errorCode, errorMessage, response);
        }
        if (ProtocolHelper.isNodeIsRecoveringError(errorCode, errorMessage)) {
            return new MongoNodeIsRecoveringException(response, serverAddress);
        }
        if (ProtocolHelper.isNotPrimaryError(errorCode, errorMessage)) {
            return new MongoNotPrimaryException(response, serverAddress);
        }
        if (response.containsKey("writeConcernError")) {
            MongoException writeConcernException = ProtocolHelper.createSpecialException(response.getDocument("writeConcernError"), serverAddress, "errmsg");
            if (writeConcernException != null && response.isArray("errorLabels")) {
                for (BsonValue errorLabel : response.getArray("errorLabels")) {
                    writeConcernException.addLabel(errorLabel.asString().getValue());
                }
            }
            return writeConcernException;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNotPrimaryError(int errorCode, String errorMessage) {
        if (NOT_PRIMARY_CODES.contains(errorCode)) return true;
        if (errorCode != -1) return false;
        if (!NOT_PRIMARY_MESSAGES.stream().anyMatch(errorMessage::contains)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNodeIsRecoveringError(int errorCode, String errorMessage) {
        if (RECOVERING_CODES.contains(errorCode)) return true;
        if (errorCode != -1) return false;
        if (!RECOVERING_MESSAGES.stream().anyMatch(errorMessage::contains)) return false;
        return true;
    }

    static void sendCommandStartedEvent(RequestMessage message, String databaseName, String commandName, BsonDocument command, ConnectionDescription connectionDescription, CommandListener commandListener, RequestContext requestContext) {
        block2: {
            Assertions.notNull("requestContext", requestContext);
            try {
                commandListener.commandStarted(new CommandStartedEvent(ProtocolHelper.getRequestContextForEvent(requestContext), message.getId(), connectionDescription, databaseName, commandName, command));
            }
            catch (Exception e) {
                if (!PROTOCOL_EVENT_LOGGER.isWarnEnabled()) break block2;
                PROTOCOL_EVENT_LOGGER.warn(String.format("Exception thrown raising command started event to listener %s", commandListener), e);
            }
        }
    }

    static void sendCommandSucceededEvent(RequestMessage message, String commandName, BsonDocument response, ConnectionDescription connectionDescription, long elapsedTimeNanos, CommandListener commandListener, RequestContext requestContext) {
        block2: {
            Assertions.notNull("requestContext", requestContext);
            try {
                commandListener.commandSucceeded(new CommandSucceededEvent(ProtocolHelper.getRequestContextForEvent(requestContext), message.getId(), connectionDescription, commandName, response, elapsedTimeNanos));
            }
            catch (Exception e) {
                if (!PROTOCOL_EVENT_LOGGER.isWarnEnabled()) break block2;
                PROTOCOL_EVENT_LOGGER.warn(String.format("Exception thrown raising command succeeded event to listener %s", commandListener), e);
            }
        }
    }

    static void sendCommandFailedEvent(RequestMessage message, String commandName, ConnectionDescription connectionDescription, long elapsedTimeNanos, Throwable throwable, CommandListener commandListener, RequestContext requestContext) {
        block2: {
            Assertions.notNull("requestContext", requestContext);
            try {
                commandListener.commandFailed(new CommandFailedEvent(ProtocolHelper.getRequestContextForEvent(requestContext), message.getId(), connectionDescription, commandName, elapsedTimeNanos, throwable));
            }
            catch (Exception e) {
                if (!PROTOCOL_EVENT_LOGGER.isWarnEnabled()) break block2;
                PROTOCOL_EVENT_LOGGER.warn(String.format("Exception thrown raising command failed event to listener %s", commandListener), e);
            }
        }
    }

    @Nullable
    private static RequestContext getRequestContextForEvent(RequestContext requestContext) {
        return requestContext == IgnorableRequestContext.INSTANCE ? null : requestContext;
    }

    private ProtocolHelper() {
    }
}

