/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection;

import io.github.apfelcreme.SupportTickets.lib.mongodb.LoggerSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCompressor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCredential;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoDriverInformation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerAddress;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerApi;
import io.github.apfelcreme.SupportTickets.lib.mongodb.annotations.ThreadSafe;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterConnectionMode;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ConnectionPoolSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ServerId;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ServerSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.StreamFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.CommandListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.Cluster;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ClusterableServer;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ClusterableServerFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DefaultConnectionFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DefaultConnectionPool;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.InternalConnectionPoolSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.InternalStreamConnectionFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.LoadBalancedServer;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.MongoCredentialWithCache;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.event.EventListenerHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.inject.EmptyProvider;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.List;

@ThreadSafe
public class LoadBalancedClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    private final ServerApi serverApi;

    public LoadBalancedClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(new ServerId(cluster.getClusterId(), serverAddress), new InternalStreamConnectionFactory(ClusterConnectionMode.LOAD_BALANCED, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, EmptyProvider.instance());
        connectionPool.ready();
        return new LoadBalancedServer(new ServerId(cluster.getClusterId(), serverAddress), connectionPool, new DefaultConnectionFactory(), EventListenerHelper.singleServerListener(this.serverSettings), cluster.getClock());
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

