/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.FieldNameValidator;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.Decoder;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ReadPreference;
import io.github.apfelcreme.SupportTickets.lib.mongodb.RequestContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerApi;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterConnectionMode;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ConnectionDescription;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.AbstractReferenceCounted;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.AsyncConnection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.CommandProtocol;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.CommandProtocolImpl;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.Connection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.InternalConnection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ProtocolExecutor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.SplittablePayload;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.diagnostics.logging.Logger;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.diagnostics.logging.Loggers;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.session.SessionContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;

public class DefaultServerConnection
extends AbstractReferenceCounted
implements Connection,
AsyncConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final InternalConnection wrapped;
    private final ProtocolExecutor protocolExecutor;
    private final ClusterConnectionMode clusterConnectionMode;

    public DefaultServerConnection(InternalConnection wrapped, ProtocolExecutor protocolExecutor, ClusterConnectionMode clusterConnectionMode) {
        this.wrapped = wrapped;
        this.protocolExecutor = protocolExecutor;
        this.clusterConnectionMode = clusterConnectionMode;
    }

    @Override
    public DefaultServerConnection retain() {
        super.retain();
        return this;
    }

    @Override
    public int release() {
        int count = super.release();
        if (count == 0) {
            this.wrapped.close();
        }
        return count;
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    @Nullable
    public <T> T command(String database, BsonDocument command, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, @Nullable ServerApi serverApi, RequestContext requestContext) {
        return this.command(database, command, fieldNameValidator, readPreference, commandResultDecoder, sessionContext, serverApi, requestContext, true, null, null);
    }

    @Override
    @Nullable
    public <T> T command(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, @Nullable ServerApi serverApi, RequestContext requestContext, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator) {
        return this.executeProtocol(new CommandProtocolImpl<T>(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, responseExpected, payload, payloadFieldNameValidator, this.clusterConnectionMode, serverApi, requestContext), sessionContext);
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, @Nullable ServerApi serverApi, RequestContext requestContext, SingleResultCallback<T> callback) {
        this.commandAsync(database, command, fieldNameValidator, readPreference, commandResultDecoder, sessionContext, serverApi, requestContext, true, null, null, callback);
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, SessionContext sessionContext, @Nullable ServerApi serverApi, RequestContext requestContext, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, SingleResultCallback<T> callback) {
        this.executeProtocolAsync(new CommandProtocolImpl<T>(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, responseExpected, payload, payloadFieldNameValidator, this.clusterConnectionMode, serverApi, requestContext), sessionContext, callback);
    }

    @Override
    public void markAsPinned(Connection.PinningMode pinningMode) {
        this.wrapped.markAsPinned(pinningMode);
    }

    @Nullable
    private <T> T executeProtocol(CommandProtocol<T> protocol, SessionContext sessionContext) {
        return this.protocolExecutor.execute(protocol, this.wrapped, sessionContext);
    }

    private <T> void executeProtocolAsync(CommandProtocol<T> protocol, SessionContext sessionContext, SingleResultCallback<T> callback) {
        SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        try {
            this.protocolExecutor.executeAsync(protocol, this.wrapped, sessionContext, errHandlingCallback);
        }
        catch (Throwable t) {
            errHandlingCallback.onResult(null, t);
        }
    }
}

