/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection;

import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterId;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ServerSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DefaultDnsSrvRecordMonitor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DnsSrvRecordInitializer;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DnsSrvRecordMonitor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.dns.DefaultDnsResolver;
import java.util.concurrent.TimeUnit;

public class DefaultDnsSrvRecordMonitorFactory
implements DnsSrvRecordMonitorFactory {
    private static final long DEFAULT_RESCAN_FREQUENCY_MILLIS = 60000L;
    private final ClusterId clusterId;
    private final long noRecordsRescanFrequency;

    public DefaultDnsSrvRecordMonitorFactory(ClusterId clusterId, ServerSettings serverSettings) {
        this.clusterId = clusterId;
        this.noRecordsRescanFrequency = serverSettings.getHeartbeatFrequency(TimeUnit.MILLISECONDS);
    }

    @Override
    public DnsSrvRecordMonitor create(String hostName, String srvServiceName, DnsSrvRecordInitializer dnsSrvRecordInitializer) {
        return new DefaultDnsSrvRecordMonitor(hostName, srvServiceName, 60000L, this.noRecordsRescanFrequency, dnsSrvRecordInitializer, this.clusterId, new DefaultDnsResolver());
    }
}

