/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection;

import io.github.apfelcreme.SupportTickets.lib.mongodb.LoggerSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCompressor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCredential;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoDriverInformation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerAddress;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerApi;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterConnectionMode;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ConnectionPoolSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ServerId;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ServerSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.StreamFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.CommandListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.ServerListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.Cluster;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ClusterableServer;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ClusterableServerFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DefaultConnectionFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DefaultConnectionPool;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DefaultSdamServerDescriptionManager;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DefaultServer;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DefaultServerMonitor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.InternalConnectionPoolSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.InternalStreamConnectionFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.MongoCredentialWithCache;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.SdamServerDescriptionManager;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.event.EventListenerHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.inject.SameObjectProvider;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final StreamFactory heartbeatStreamFactory;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    @Nullable
    private final ServerApi serverApi;

    public DefaultClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.heartbeatStreamFactory = heartbeatStreamFactory;
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        ServerId serverId = new ServerId(cluster.getClusterId(), serverAddress);
        ClusterConnectionMode clusterMode = cluster.getSettings().getMode();
        SameObjectProvider<SdamServerDescriptionManager> sdamProvider = SameObjectProvider.uninitialized();
        DefaultServerMonitor serverMonitor = new DefaultServerMonitor(serverId, this.serverSettings, cluster.getClock(), new InternalStreamConnectionFactory(clusterMode, true, this.heartbeatStreamFactory, null, this.applicationName, this.mongoDriverInformation, Collections.emptyList(), this.loggerSettings, null, this.serverApi), clusterMode, this.serverApi, sdamProvider);
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(serverId, new InternalStreamConnectionFactory(clusterMode, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, sdamProvider);
        ServerListener serverListener = EventListenerHelper.singleServerListener(this.serverSettings);
        DefaultSdamServerDescriptionManager sdam = new DefaultSdamServerDescriptionManager(cluster, serverId, serverListener, serverMonitor, connectionPool, clusterMode);
        sdamProvider.initialize(sdam);
        serverMonitor.start();
        return new DefaultServer(serverId, clusterMode, connectionPool, new DefaultConnectionFactory(), serverMonitor, sdam, serverListener, this.commandListener, cluster.getClock(), true);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

