/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection;

import io.github.apfelcreme.SupportTickets.lib.mongodb.LoggerSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCompressor;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCredential;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoDriverInformation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerApi;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterConnectionMode;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterId;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ConnectionPoolSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ServerSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.StreamFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.ClusterListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.CommandListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.ServerListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.event.ServerMonitorListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.AsynchronousClusterEventListener;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.Cluster;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DefaultClusterableServerFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DefaultDnsSrvRecordMonitorFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.DnsMultiServerCluster;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.InternalConnectionPoolSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.LoadBalancedCluster;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.LoadBalancedClusterableServerFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.MultiServerCluster;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.SingleServerCluster;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.event.EventListenerHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;

public final class DefaultClusterFactory {
    public Cluster createCluster(ClusterSettings originalClusterSettings, ServerSettings originalServerSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi) {
        ServerSettings serverSettings;
        ClusterSettings clusterSettings;
        ClusterId clusterId = new ClusterId(applicationName);
        if (this.noClusterEventListeners(originalClusterSettings, originalServerSettings)) {
            clusterSettings = ClusterSettings.builder(originalClusterSettings).clusterListenerList(Collections.singletonList(EventListenerHelper.NO_OP_CLUSTER_LISTENER)).build();
            serverSettings = ServerSettings.builder(originalServerSettings).serverListenerList(Collections.singletonList(EventListenerHelper.NO_OP_SERVER_LISTENER)).serverMonitorListenerList(Collections.singletonList(EventListenerHelper.NO_OP_SERVER_MONITOR_LISTENER)).build();
        } else {
            AsynchronousClusterEventListener clusterEventListener = AsynchronousClusterEventListener.startNew(clusterId, DefaultClusterFactory.getClusterListener(originalClusterSettings), DefaultClusterFactory.getServerListener(originalServerSettings), DefaultClusterFactory.getServerMonitorListener(originalServerSettings));
            clusterSettings = ClusterSettings.builder(originalClusterSettings).clusterListenerList(Collections.singletonList(clusterEventListener)).build();
            serverSettings = ServerSettings.builder(originalServerSettings).serverListenerList(Collections.singletonList(clusterEventListener)).serverMonitorListenerList(Collections.singletonList(clusterEventListener)).build();
        }
        DefaultDnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory = new DefaultDnsSrvRecordMonitorFactory(clusterId, serverSettings);
        if (clusterSettings.getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            LoadBalancedClusterableServerFactory serverFactory = new LoadBalancedClusterableServerFactory(serverSettings, connectionPoolSettings, internalConnectionPoolSettings, streamFactory, credential, loggerSettings, commandListener, applicationName, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), compressorList, serverApi);
            return new LoadBalancedCluster(clusterId, clusterSettings, serverFactory, dnsSrvRecordMonitorFactory);
        }
        DefaultClusterableServerFactory serverFactory = new DefaultClusterableServerFactory(serverSettings, connectionPoolSettings, internalConnectionPoolSettings, streamFactory, heartbeatStreamFactory, credential, loggerSettings, commandListener, applicationName, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), compressorList, serverApi);
        if (clusterSettings.getMode() == ClusterConnectionMode.SINGLE) {
            return new SingleServerCluster(clusterId, clusterSettings, serverFactory);
        }
        if (clusterSettings.getMode() == ClusterConnectionMode.MULTIPLE) {
            if (clusterSettings.getSrvHost() == null) {
                return new MultiServerCluster(clusterId, clusterSettings, serverFactory);
            }
            return new DnsMultiServerCluster(clusterId, clusterSettings, serverFactory, dnsSrvRecordMonitorFactory);
        }
        throw new UnsupportedOperationException("Unsupported cluster mode: " + (Object)((Object)clusterSettings.getMode()));
    }

    private boolean noClusterEventListeners(ClusterSettings clusterSettings, ServerSettings serverSettings) {
        return clusterSettings.getClusterListeners().isEmpty() && serverSettings.getServerListeners().isEmpty() && serverSettings.getServerMonitorListeners().isEmpty();
    }

    private static ClusterListener getClusterListener(ClusterSettings clusterSettings) {
        return clusterSettings.getClusterListeners().size() == 0 ? EventListenerHelper.NO_OP_CLUSTER_LISTENER : EventListenerHelper.clusterListenerMulticaster(clusterSettings.getClusterListeners());
    }

    private static ServerListener getServerListener(ServerSettings serverSettings) {
        return serverSettings.getServerListeners().size() == 0 ? EventListenerHelper.NO_OP_SERVER_LISTENER : EventListenerHelper.serverListenerMulticaster(serverSettings.getServerListeners());
    }

    private static ServerMonitorListener getServerMonitorListener(ServerSettings serverSettings) {
        return serverSettings.getServerMonitorListeners().size() == 0 ? EventListenerHelper.NO_OP_SERVER_MONITOR_LISTENER : EventListenerHelper.serverMonitorListenerMulticaster(serverSettings.getServerMonitorListeners());
    }
}

