/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonDocumentCodec;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoNamespace;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoServerException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ReadPreference;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerApi;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterConnectionMode;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.IgnorableRequestContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ClusterClock;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.CommandMessage;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.InternalConnection;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.MessageSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.NoOpSessionContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.session.SessionContext;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.validator.NoOpFieldNameValidator;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.Locale;

public final class CommandHelper {
    static final String HELLO = "hello";
    static final String LEGACY_HELLO = "isMaster";
    static final String LEGACY_HELLO_LOWER = "isMaster".toLowerCase(Locale.ROOT);

    static BsonDocument executeCommand(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, null, clusterConnectionMode, serverApi, internalConnection);
    }

    public static BsonDocument executeCommand(String database, BsonDocument command, ClusterClock clusterClock, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        return CommandHelper.sendAndReceive(database, command, clusterClock, clusterConnectionMode, serverApi, internalConnection);
    }

    static BsonDocument executeCommandWithoutCheckingForFailure(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        try {
            return CommandHelper.sendAndReceive(database, command, null, clusterConnectionMode, serverApi, internalConnection);
        }
        catch (MongoServerException e) {
            return new BsonDocument();
        }
    }

    static void executeCommandAsync(String database, BsonDocument command, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection, SingleResultCallback<BsonDocument> callback) {
        internalConnection.sendAndReceiveAsync(CommandHelper.getCommandMessage(database, command, internalConnection, clusterConnectionMode, serverApi), new BsonDocumentCodec(), NoOpSessionContext.INSTANCE, IgnorableRequestContext.INSTANCE, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult((BsonDocument)result, null);
            }
        });
    }

    static boolean isCommandOk(BsonDocument response) {
        if (!response.containsKey("ok")) {
            return false;
        }
        BsonValue okValue = response.get("ok");
        if (okValue.isBoolean()) {
            return okValue.asBoolean().getValue();
        }
        if (okValue.isNumber()) {
            return okValue.asNumber().intValue() == 1;
        }
        return false;
    }

    private static BsonDocument sendAndReceive(String database, BsonDocument command, @Nullable ClusterClock clusterClock, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, InternalConnection internalConnection) {
        SessionContext sessionContext = clusterClock == null ? NoOpSessionContext.INSTANCE : new ClusterClockAdvancingSessionContext(NoOpSessionContext.INSTANCE, clusterClock);
        return Assertions.assertNotNull(internalConnection.sendAndReceive(CommandHelper.getCommandMessage(database, command, internalConnection, clusterConnectionMode, serverApi), new BsonDocumentCodec(), sessionContext, IgnorableRequestContext.INSTANCE));
    }

    private static CommandMessage getCommandMessage(String database, BsonDocument command, InternalConnection internalConnection, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        return new CommandMessage(new MongoNamespace(database, "$cmd"), command, new NoOpFieldNameValidator(), ReadPreference.primary(), MessageSettings.builder().maxWireVersion(internalConnection.getDescription().getMaxWireVersion()).serverType(internalConnection.getDescription().getServerType()).build(), clusterConnectionMode, serverApi);
    }

    private CommandHelper() {
    }
}

