/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonBinary;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonBinaryWriter;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonInt32;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonString;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonWriter;
import io.github.apfelcreme.SupportTickets.lib.bson.RawBsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.BsonDocumentCodec;
import io.github.apfelcreme.SupportTickets.lib.bson.codecs.EncoderContext;
import io.github.apfelcreme.SupportTickets.lib.bson.io.BasicOutputBuffer;
import io.github.apfelcreme.SupportTickets.lib.mongodb.AuthenticationMechanism;
import io.github.apfelcreme.SupportTickets.lib.mongodb.AwsCredential;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoClientException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoCredential;
import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerAddress;
import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerApi;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.ClusterConnectionMode;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.authentication.AwsCredentialHelper;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.AuthorizationHeader;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.MongoCredentialWithCache;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.SaslAuthenticator;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class AwsAuthenticator
extends SaslAuthenticator {
    private static final String MONGODB_AWS_MECHANISM_NAME = "MONGODB-AWS";
    private static final int RANDOM_LENGTH = 32;

    public AwsAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
        if (this.getMongoCredential().getAuthenticationMechanism() != AuthenticationMechanism.MONGODB_AWS) {
            throw new MongoException("Incorrect mechanism: " + this.getMongoCredential().getMechanism());
        }
    }

    @Override
    public String getMechanismName() {
        return MONGODB_AWS_MECHANISM_NAME;
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        return new AwsSaslClient(this.getMongoCredential());
    }

    private static class AwsSaslClient
    implements SaslClient {
        private final MongoCredential credential;
        private final byte[] clientNonce = new byte[32];
        private int step = -1;

        AwsSaslClient(MongoCredential credential) {
            this.credential = credential;
        }

        @Override
        public String getMechanismName() {
            AuthenticationMechanism authMechanism = this.credential.getAuthenticationMechanism();
            if (authMechanism == null) {
                throw new IllegalArgumentException("Authentication mechanism cannot be null");
            }
            return authMechanism.getMechanismName();
        }

        @Override
        public boolean hasInitialResponse() {
            return true;
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
            ++this.step;
            if (this.step == 0) {
                return this.computeClientFirstMessage();
            }
            if (this.step == 1) {
                return this.computeClientFinalMessage(challenge);
            }
            throw new SaslException(String.format("Too many steps involved in the %s negotiation.", this.getMechanismName()));
        }

        @Override
        public boolean isComplete() {
            return this.step == 1;
        }

        @Override
        public byte[] unwrap(byte[] bytes, int i, int i1) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        @Override
        public byte[] wrap(byte[] bytes, int i, int i1) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        @Override
        public Object getNegotiatedProperty(String s) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        @Override
        public void dispose() {
        }

        private byte[] computeClientFirstMessage() {
            new SecureRandom().nextBytes(this.clientNonce);
            BsonDocument document = new BsonDocument().append("r", new BsonBinary(this.clientNonce)).append("p", new BsonInt32(110));
            return this.toBson(document);
        }

        private byte[] computeClientFinalMessage(byte[] serverFirst) throws SaslException {
            RawBsonDocument document = new RawBsonDocument(serverFirst);
            String host = document.getString("h").getValue();
            byte[] serverNonce = document.getBinary("s").getData();
            if (serverNonce.length != 64) {
                throw new SaslException(String.format("Server nonce must be %d bytes", 64));
            }
            if (!Arrays.equals(Arrays.copyOf(serverNonce, 32), this.clientNonce)) {
                throw new SaslException(String.format("The first %d bytes of the server nonce must be the client nonce", 32));
            }
            String timestamp = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'").withZone(ZoneId.of("UTC")).format(Instant.now());
            AwsCredential awsCredential = this.createAwsCredential();
            String sessionToken = awsCredential.getSessionToken();
            AuthorizationHeader authorizationHeader = AuthorizationHeader.builder().setAccessKeyID(awsCredential.getAccessKeyId()).setSecretKey(awsCredential.getSecretAccessKey()).setSessionToken(sessionToken).setHost(host).setNonce(serverNonce).setTimestamp(timestamp).build();
            BsonDocument ret = new BsonDocument().append("a", new BsonString(authorizationHeader.toString())).append("d", new BsonString(authorizationHeader.getTimestamp()));
            if (sessionToken != null) {
                ret.append("t", new BsonString(sessionToken));
            }
            return this.toBson(ret);
        }

        private AwsCredential createAwsCredential() {
            AwsCredential awsCredential;
            if (this.credential.getUserName() != null) {
                if (this.credential.getPassword() == null) {
                    throw new MongoClientException("secretAccessKey is required for AWS credential");
                }
                awsCredential = new AwsCredential(Assertions.assertNotNull(this.credential.getUserName()), new String(Assertions.assertNotNull(this.credential.getPassword())), this.credential.getMechanismProperty("AWS_SESSION_TOKEN", null));
            } else if (this.credential.getMechanismProperty("AWS_CREDENTIAL_PROVIDER", null) != null) {
                Supplier awsCredentialSupplier = Assertions.assertNotNull(this.credential.getMechanismProperty("AWS_CREDENTIAL_PROVIDER", null));
                awsCredential = (AwsCredential)awsCredentialSupplier.get();
                if (awsCredential == null) {
                    throw new MongoClientException("AWS_CREDENTIAL_PROVIDER_KEY must return an AwsCredential instance");
                }
            } else {
                awsCredential = AwsCredentialHelper.obtainFromEnvironment();
                if (awsCredential == null) {
                    throw new MongoClientException("Unable to obtain AWS credential from the environment");
                }
            }
            return awsCredential;
        }

        private byte[] toBson(BsonDocument document) {
            BasicOutputBuffer buffer = new BasicOutputBuffer();
            new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter(buffer), document, EncoderContext.builder().build());
            byte[] bytes = new byte[buffer.size()];
            System.arraycopy(buffer.getInternalBuffer(), 0, bytes, 0, buffer.getSize());
            return bytes;
        }
    }
}

