/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.function;

import io.github.apfelcreme.SupportTickets.lib.mongodb.annotations.NotThreadSafe;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.SingleResultCallback;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.function.AsyncCallbackSupplier;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.async.function.RetryState;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

@NotThreadSafe
public final class RetryingAsyncCallbackSupplier<R>
implements AsyncCallbackSupplier<R> {
    private final RetryState state;
    private final BiPredicate<RetryState, Throwable> retryPredicate;
    private final BiFunction<Throwable, Throwable, Throwable> failedResultTransformer;
    private final AsyncCallbackSupplier<R> asyncFunction;

    public RetryingAsyncCallbackSupplier(RetryState state, BiFunction<Throwable, Throwable, Throwable> failedResultTransformer, BiPredicate<RetryState, Throwable> retryPredicate, AsyncCallbackSupplier<R> asyncFunction) {
        this.state = state;
        this.retryPredicate = retryPredicate;
        this.failedResultTransformer = failedResultTransformer;
        this.asyncFunction = asyncFunction;
    }

    @Override
    public void get(SingleResultCallback<R> callback) {
        this.asyncFunction.get(new RetryingCallback(callback));
    }

    @NotThreadSafe
    private class RetryingCallback
    implements SingleResultCallback<R> {
        private final SingleResultCallback<R> wrapped;

        RetryingCallback(SingleResultCallback<R> callback) {
            this.wrapped = callback;
        }

        @Override
        public void onResult(@Nullable R result, @Nullable Throwable t) {
            if (t != null) {
                try {
                    RetryingAsyncCallbackSupplier.this.state.advanceOrThrow(t, (BiFunction<Throwable, Throwable, Throwable>)RetryingAsyncCallbackSupplier.this.failedResultTransformer, (BiPredicate<RetryState, Throwable>)RetryingAsyncCallbackSupplier.this.retryPredicate);
                }
                catch (Throwable failedResult) {
                    this.wrapped.onResult(null, failedResult);
                    return;
                }
                RetryingAsyncCallbackSupplier.this.asyncFunction.get(this);
            } else {
                this.wrapped.onResult(result, null);
            }
        }
    }
}

