/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal;

import io.github.apfelcreme.SupportTickets.lib.mongodb.annotations.Immutable;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
public final class Timeout {
    private static final Timeout INFINITE = new Timeout(-1L, 0L);
    private static final Timeout IMMEDIATE = new Timeout(0L, 0L);
    private final long durationNanos;
    private final long startNanos;

    private Timeout(long durationNanos, long startNanos) {
        this.durationNanos = durationNanos;
        this.startNanos = startNanos;
    }

    public static Timeout startNow(long duration, TimeUnit unit) {
        Assertions.assertNotNull(unit);
        return Timeout.startNow(unit.toNanos(duration));
    }

    public static Timeout startNow(long durationNanos) {
        if (durationNanos < 0L || durationNanos == Long.MAX_VALUE) {
            return Timeout.infinite();
        }
        if (durationNanos == 0L) {
            return Timeout.immediate();
        }
        return new Timeout(durationNanos, System.nanoTime());
    }

    public static Timeout infinite() {
        return INFINITE;
    }

    public static Timeout immediate() {
        return IMMEDIATE;
    }

    private long elapsedNanos(long currentNanos) {
        Assertions.assertFalse(this.isInfinite() || this.isImmediate());
        return currentNanos - this.startNanos;
    }

    long remainingNanos(long currentNanos) {
        Assertions.assertFalse(this.isInfinite() || this.isImmediate());
        long elapsedNanos = this.elapsedNanos(currentNanos);
        return elapsedNanos < 0L ? 0L : Math.max(0L, this.durationNanos - elapsedNanos);
    }

    public long remaining(TimeUnit unit) throws UnsupportedOperationException {
        Assertions.assertNotNull(unit);
        if (this.isInfinite()) {
            throw new UnsupportedOperationException();
        }
        return this.isImmediate() ? 0L : Timeout.convertRoundUp(this.remainingNanos(System.nanoTime()), unit);
    }

    public long remainingOrInfinite(TimeUnit unit) {
        Assertions.assertNotNull(unit);
        return this.isInfinite() ? -1L : this.remaining(unit);
    }

    public boolean expired() {
        return Timeout.expired(this.remainingOrInfinite(TimeUnit.NANOSECONDS));
    }

    public static boolean expired(long remaining) {
        return remaining == 0L;
    }

    public boolean isInfinite() {
        return this.equals(INFINITE);
    }

    public boolean isImmediate() {
        return this.equals(IMMEDIATE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timeout other = (Timeout)o;
        return this.durationNanos == other.durationNanos && this.startNanos == other.startNanos;
    }

    public int hashCode() {
        return Objects.hash(this.durationNanos, this.startNanos);
    }

    public String toString() {
        return "Timeout{durationNanos=" + this.durationNanos + ", startNanos=" + this.startNanos + '}';
    }

    public String toUserString() {
        if (this.isInfinite()) {
            return "infinite";
        }
        if (this.isImmediate()) {
            return "0 ms (immediate)";
        }
        return Timeout.convertRoundUp(this.durationNanos, TimeUnit.MILLISECONDS) + " ms";
    }

    long durationNanos() {
        return this.durationNanos;
    }

    long startNanos() {
        return this.startNanos;
    }

    static long convertRoundUp(long nonNegativeNanos, TimeUnit unit) {
        Assertions.assertTrue(nonNegativeNanos >= 0L);
        if (unit == TimeUnit.NANOSECONDS) {
            return nonNegativeNanos;
        }
        long trimmed = unit.convert(nonNegativeNanos, TimeUnit.NANOSECONDS);
        return TimeUnit.NANOSECONDS.convert(trimmed, unit) < nonNegativeNanos ? trimmed + 1L : trimmed;
    }
}

