/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.internal;

import io.github.apfelcreme.SupportTickets.lib.mongodb.MongoInterruptedException;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.CheckedSupplier;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

public final class Locks {
    public static void withLock(Lock lock, Runnable action) {
        Locks.withLock(lock, () -> {
            action.run();
            return null;
        });
    }

    public static <V> V withLock(Lock lock, Supplier<V> supplier) {
        return (V)Locks.checkedWithLock(lock, supplier::get);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <V, E extends Exception> V checkedWithLock(Lock lock, CheckedSupplier<V, E> supplier) throws E {
        try {
            lock.lockInterruptibly();
            try {
                V v = supplier.get();
                return v;
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MongoInterruptedException("Interrupted waiting for lock", e);
        }
    }

    private Locks() {
    }
}

