/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.connection;

import io.github.apfelcreme.SupportTickets.lib.mongodb.ServerAddress;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.SocketSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.SslSettings;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.Stream;
import io.github.apfelcreme.SupportTickets.lib.mongodb.connection.StreamFactory;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.AsynchronousSocketChannelStream;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.connection.PowerOfTwoBufferPool;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.nio.channels.AsynchronousChannelGroup;

public class AsynchronousSocketChannelStreamFactory
implements StreamFactory {
    private final PowerOfTwoBufferPool bufferProvider = PowerOfTwoBufferPool.DEFAULT;
    private final SocketSettings settings;
    private final AsynchronousChannelGroup group;

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this(settings, sslSettings, null);
    }

    public AsynchronousSocketChannelStreamFactory(SocketSettings settings, SslSettings sslSettings, @Nullable AsynchronousChannelGroup group) {
        if (sslSettings.isEnabled()) {
            throw new UnsupportedOperationException("No SSL support in java.nio.channels.AsynchronousSocketChannel. For SSL support use com.mongodb.connection.TlsChannelStreamFactoryFactory");
        }
        this.settings = Assertions.notNull("settings", settings);
        this.group = group;
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        return new AsynchronousSocketChannelStream(serverAddress, this.settings, this.bufferProvider, this.group);
    }
}

