/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonDouble;
import io.github.apfelcreme.SupportTickets.lib.bson.Document;
import io.github.apfelcreme.SupportTickets.lib.bson.conversions.Bson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.annotations.Beta;
import io.github.apfelcreme.SupportTickets.lib.mongodb.annotations.Evolving;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.ConstantSearchScore;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.FieldSearchPath;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.FunctionSearchScore;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.PathBoostSearchScore;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.SearchConstructibleBsonElement;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.SearchScoreExpression;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.ValueBoostSearchScore;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchScore
extends Bson {
    public static ValueBoostSearchScore boost(float value) {
        return new SearchConstructibleBsonElement("boost", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static PathBoostSearchScore boost(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("boost", (Bson)new Document("path", Assertions.notNull("value", path).toValue()));
    }

    public static ConstantSearchScore constant(float value) {
        return new SearchConstructibleBsonElement("constant", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static FunctionSearchScore function(SearchScoreExpression expression) {
        return new SearchConstructibleBsonElement("function", (Bson)Assertions.notNull("expression", expression));
    }

    public static SearchScore of(Bson score) {
        return new SearchConstructibleBsonElement(Assertions.notNull("score", score));
    }
}

