/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonString;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.conversions.Bson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.annotations.Beta;
import io.github.apfelcreme.SupportTickets.lib.mongodb.annotations.Evolving;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.FieldSearchPath;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.SearchConstructibleBson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.WildcardSearchPath;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchPath
extends Bson {
    public static FieldSearchPath fieldPath(String path) {
        Assertions.notNull("path", path);
        Assertions.isTrueArgument("path must not contain '*'", !path.contains("*"));
        return new SearchConstructibleBson(new BsonDocument("value", new BsonString(path)));
    }

    public static WildcardSearchPath wildcardPath(String wildcardPath) {
        Assertions.notNull("wildcardPath", wildcardPath);
        Assertions.isTrueArgument("wildcardPath must contain '*'", wildcardPath.contains("*"));
        Assertions.isTrueArgument("wildcardPath must not contain '**'", !wildcardPath.contains("**"));
        return new SearchConstructibleBson(new BsonDocument("wildcard", new BsonString(wildcardPath)));
    }

    default public BsonValue toBsonValue() {
        BsonDocument doc = this.toBsonDocument();
        if (doc.size() > 1) {
            return doc;
        }
        BsonString value = doc.getString("value", null);
        if (value != null) {
            return value;
        }
        return doc;
    }
}

