/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonDocument;
import io.github.apfelcreme.SupportTickets.lib.bson.conversions.Bson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.annotations.Beta;
import io.github.apfelcreme.SupportTickets.lib.mongodb.annotations.Evolving;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.SearchConstructibleBson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.search.SearchPath;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.Iterables;
import io.github.apfelcreme.SupportTickets.lib.mongodb.internal.client.model.Util;
import java.util.Iterator;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchHighlight
extends Bson {
    public SearchHighlight maxCharsToExamine(int var1);

    public SearchHighlight maxNumPassages(int var1);

    public static SearchHighlight paths(SearchPath path, SearchPath ... paths) {
        return SearchHighlight.paths(Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static SearchHighlight paths(Iterable<? extends SearchPath> paths) {
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBson(new BsonDocument("path", Util.combineToBsonValue(pathIterator, false)));
    }

    public static SearchHighlight of(Bson highlight) {
        return new SearchConstructibleBson(Assertions.notNull("highlight", highlight));
    }
}

