/*
 * Decompiled with CFR 0.152.
 */
package io.github.apfelcreme.SupportTickets.lib.mongodb.client.model;

import io.github.apfelcreme.SupportTickets.lib.bson.BsonString;
import io.github.apfelcreme.SupportTickets.lib.bson.BsonValue;
import io.github.apfelcreme.SupportTickets.lib.bson.conversions.Bson;
import io.github.apfelcreme.SupportTickets.lib.mongodb.assertions.Assertions;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.Collation;
import io.github.apfelcreme.SupportTickets.lib.mongodb.client.model.ReturnDocument;
import io.github.apfelcreme.SupportTickets.lib.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public class FindOneAndReplaceOptions {
    private Bson projection;
    private Bson sort;
    private boolean upsert;
    private ReturnDocument returnDocument = ReturnDocument.BEFORE;
    private long maxTimeMS;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private Bson hint;
    private String hintString;
    private BsonValue comment;
    private Bson variables;

    @Nullable
    public Bson getProjection() {
        return this.projection;
    }

    public FindOneAndReplaceOptions projection(@Nullable Bson projection) {
        this.projection = projection;
        return this;
    }

    @Nullable
    public Bson getSort() {
        return this.sort;
    }

    public FindOneAndReplaceOptions sort(@Nullable Bson sort) {
        this.sort = sort;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindOneAndReplaceOptions upsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public ReturnDocument getReturnDocument() {
        return this.returnDocument;
    }

    public FindOneAndReplaceOptions returnDocument(ReturnDocument returnDocument) {
        this.returnDocument = Assertions.notNull("returnDocument", returnDocument);
        return this;
    }

    public FindOneAndReplaceOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public FindOneAndReplaceOptions bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    public FindOneAndReplaceOptions collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    public Bson getHint() {
        return this.hint;
    }

    public FindOneAndReplaceOptions hint(@Nullable Bson hint) {
        this.hint = hint;
        return this;
    }

    @Nullable
    public String getHintString() {
        return this.hintString;
    }

    public FindOneAndReplaceOptions hintString(@Nullable String hint) {
        this.hintString = hint;
        return this;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public FindOneAndReplaceOptions comment(@Nullable String comment) {
        this.comment = comment != null ? new BsonString(comment) : null;
        return this;
    }

    public FindOneAndReplaceOptions comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    public Bson getLet() {
        return this.variables;
    }

    public FindOneAndReplaceOptions let(Bson variables) {
        this.variables = variables;
        return this;
    }

    public String toString() {
        return "FindOneAndReplaceOptions{projection=" + this.projection + ", sort=" + this.sort + ", upsert=" + this.upsert + ", returnDocument=" + (Object)((Object)this.returnDocument) + ", maxTimeMS=" + this.maxTimeMS + ", bypassDocumentValidation=" + this.bypassDocumentValidation + ", collation=" + this.collation + ", hint=" + this.hint + ", hintString" + this.hintString + ", comment=" + this.comment + ", let=" + this.variables + '}';
    }
}

